/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;

public class FileDiffer {
    public boolean diff(File first, File second) {
        try {
            this.verifyDirsAreEqual(first.toPath(), second.toPath());
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public void verifyDirsAreEqual(final Path first, final Path second) throws Exception {
        Files.walkFileTree(first, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                byte[] thisBytes;
                FileVisitResult result = super.visitFile(file, attrs);
                Path relativize = first.relativize(file);
                Path fileInOther = second.resolve(relativize);
                byte[] otherBytes = Files.readAllBytes(fileInOther);
                if (!Arrays.equals(otherBytes, thisBytes = Files.readAllBytes(file))) {
                    result = null;
                    throw new RuntimeException(file + " is not equal to " + fileInOther);
                }
                return result;
            }
        });
    }
}

