/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class Dates {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    static final Map<Month, Integer> monthToQuarterMap = new HashMap<Month, Integer>(){
        private static final long serialVersionUID = 956494200361042014L;
        {
            this.put(Month.JANUARY, 1);
            this.put(Month.FEBRUARY, 1);
            this.put(Month.MARCH, 1);
            this.put(Month.APRIL, 2);
            this.put(Month.MAY, 2);
            this.put(Month.JUNE, 2);
            this.put(Month.JULY, 3);
            this.put(Month.AUGUST, 3);
            this.put(Month.SEPTEMBER, 3);
            this.put(Month.OCTOBER, 4);
            this.put(Month.NOVEMBER, 4);
            this.put(Month.DECEMBER, 4);
        }
    };
    static final Map<Month, Integer> monthToBiannualMap = new HashMap<Month, Integer>(){
        private static final long serialVersionUID = 956494200361042014L;
        {
            this.put(Month.JANUARY, 1);
            this.put(Month.FEBRUARY, 1);
            this.put(Month.MARCH, 1);
            this.put(Month.APRIL, 1);
            this.put(Month.MAY, 1);
            this.put(Month.JUNE, 1);
            this.put(Month.JULY, 2);
            this.put(Month.AUGUST, 2);
            this.put(Month.SEPTEMBER, 2);
            this.put(Month.OCTOBER, 2);
            this.put(Month.NOVEMBER, 2);
            this.put(Month.DECEMBER, 2);
        }
    };

    public static final Date toDate(String dateValue, String format, String timeZone) throws ParseException {
        return Dates.toDate(dateValue, format, TimeZone.getTimeZone(timeZone));
    }

    public static final Date toDate(String dateValue, String format, TimeZone timeZone) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.parse(dateValue);
    }

    public static final Date toDate(String dateValue, String format) throws ParseException {
        return Dates.toDate(dateValue, format, DEFAULT_TIME_ZONE);
    }

    public static Date toDate(LocalDate localDate) {
        return localDate != null ? Date.from(localDate.atStartOfDay().atZone(DEFAULT_TIME_ZONE.toZoneId()).toInstant()) : null;
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return localDateTime != null ? Date.from(localDateTime.atZone(DEFAULT_TIME_ZONE.toZoneId()).toInstant()) : null;
    }

    public static LocalDate toLocalDate(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(DEFAULT_TIME_ZONE.toZoneId()).toLocalDate() : null;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(DEFAULT_TIME_ZONE.toZoneId()).toLocalDateTime() : null;
    }

    public static LocalDateTime toLocalDateTime(Long timestamp) {
        return timestamp != null ? Instant.ofEpochMilli(timestamp).atZone(DEFAULT_TIME_ZONE.toZoneId()).toLocalDateTime() : null;
    }

    public static String toString(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(formatter);
    }

    public static String toString(long time, String pattern) {
        LocalDateTime localdateTime = Dates.fromTime(time);
        return Dates.toString(localdateTime, pattern);
    }

    public static String toString(String pattern) {
        LocalDateTime localdateTime = Dates.fromTime(Dates.toTime());
        return Dates.toString(localdateTime, pattern);
    }

    public static LocalDateTime fromString(String localDateTime) {
        return localDateTime != null ? LocalDateTime.parse(localDateTime) : null;
    }

    public static Long toTime(String localDateTime) {
        return localDateTime != null ? Long.valueOf(LocalDateTime.parse(localDateTime).atZone(DEFAULT_TIME_ZONE.toZoneId()).toInstant().toEpochMilli()) : null;
    }

    public static Long toTime(LocalDateTime localDateTime) {
        if (localDateTime != null) {
            return localDateTime.atZone(DEFAULT_TIME_ZONE.toZoneId()).toInstant().toEpochMilli();
        }
        return null;
    }

    public static LocalDateTime fromTime(Long time) {
        if (time != null) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), DEFAULT_TIME_ZONE.toZoneId());
        }
        return null;
    }

    public static Long toTime() {
        Instant instant = Instant.now().atZone(DEFAULT_TIME_ZONE.toZoneId()).toInstant();
        long epochMilli = instant.toEpochMilli();
        return epochMilli;
    }

    public static Long toTime(String dateValue, String format) throws ParseException {
        return Dates.toTime(dateValue, format, DEFAULT_TIME_ZONE);
    }

    public static Long toTime(String dateValue, String format, String timeZone) throws ParseException {
        return Dates.toTime(dateValue, format, TimeZone.getTimeZone(timeZone));
    }

    public static Long toTime(String dateValue, String format, TimeZone timeZone) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(timeZone);
        Date date = dateFormat.parse(dateValue);
        return Dates.toTime(date);
    }

    public static Long toTime(Date date) {
        return date != null ? Long.valueOf(date.getTime()) : null;
    }

    public static Date toDate(Long time) {
        return time != null ? new Date(time) : null;
    }

    public static Long toTime(Operation operation, long units, ChronoUnit unit) {
        LocalDateTime now = Dates.fromTime(Dates.toTime());
        LocalDateTime result = operation == Operation.PLUS ? now.plus(units, unit) : now.minus(units, unit);
        return Dates.toTime(result);
    }

    public static String durationToHHMMSS(long milliseconds) {
        Duration duration = Duration.ofMillis(milliseconds);
        return String.format("%02d:%02d:%02d (HH:mm:ss)", duration.toHours(), duration.minusHours(duration.toHours()).toMinutes(), duration.minusMinutes(duration.toMinutes()).getSeconds());
    }

    public static int asYear(Long timestamp) {
        return Dates.toLocalDateTime(timestamp).getYear();
    }

    public static Month asMonth(Long timestamp) {
        return Dates.toLocalDateTime(timestamp).getMonth();
    }

    public static Integer asQuarter(Long timestamp) {
        return monthToQuarterMap.get(Dates.toLocalDateTime(timestamp).getMonth());
    }

    public static Integer asBiannual(Long timestamp) {
        return monthToBiannualMap.get(Dates.toLocalDateTime(timestamp).getMonth());
    }

    public static int asDayOfMonth(Long timestamp) {
        return Dates.toLocalDateTime(timestamp).getDayOfMonth();
    }

    public static enum Operation {
        PLUS,
        MINUS;

    }
}

