/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Collections {
    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, collection.size());
        Iterator<T> iterator = collection.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            array[index++] = iterator.next();
        }
        return array;
    }

    @SafeVarargs
    public static <T> T[] newArray(T ... elements) {
        if (elements != null && elements.length > 0) {
            return elements;
        }
        return null;
    }

    public static <T> List<T> newList() {
        return new ArrayList();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... elements) {
        HashSet<T> set = Collections.newHashSet();
        if (elements != null && elements.length > 0) {
            for (T element : elements) {
                if (element == null) continue;
                set.add(element);
            }
        }
        return set;
    }

    @SafeVarargs
    public static <T> List<T> newList(T ... elements) {
        List<T> list = Collections.newList();
        if (elements != null && elements.length > 0) {
            for (T element : elements) {
                if (element == null) continue;
                list.add(element);
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> newList(Collection<T> collection, T ... elements) {
        List<T> union = Collections.newList();
        if (collection != null && collection.size() > 0) {
            union.addAll(collection);
        }
        if (elements != null && elements.length > 0) {
            for (T element : elements) {
                if (element == null) continue;
                union.add(element);
            }
        }
        return union;
    }

    @SafeVarargs
    public static <T> List<T> newList(Collection<T> ... collections) {
        List<T> union = Collections.newList();
        if (collections != null && collections.length > 0) {
            for (Collection<T> collection : collections) {
                if (collection == null || collection.size() <= 0) continue;
                union.addAll(collection);
            }
        }
        return union;
    }
}

