/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.config.HttpClientConfig;

class WrappedHttpClientConfig {
    private final HttpClientConfig httpClientConfig;
    private final int ioThreadCount;

    protected WrappedHttpClientConfig(Builder builder) {
        this.httpClientConfig = builder.httpClientConfig;
        this.ioThreadCount = builder.ioThreadCount;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public static class Builder {
        protected int ioThreadCount = Runtime.getRuntime().availableProcessors();
        private final HttpClientConfig httpClientConfig;

        public Builder(HttpClientConfig httpClientConfig) {
            this.httpClientConfig = httpClientConfig;
        }

        public WrappedHttpClientConfig build() {
            return new WrappedHttpClientConfig(this);
        }

        public Builder ioThreadCount(int ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }
    }
}

