/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.config.HttpClientConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.log4j2.elasticsearch.CertInfo;
import org.appenders.log4j2.elasticsearch.jest.thirdparty.PemReader;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@Plugin(name="PEM", category="Core", elementType="certInfo")
public class PEMCertInfo
implements CertInfo<HttpClientConfig.Builder> {
    static final String PLUGIN_NAME = "PEM";
    private final String keyPath;
    private final String keyPassphrase;
    private final String clientCertPath;
    private final String caPath;
    static final String configExceptionMessage = "Failed to apply SSL/TLS settings";

    protected PEMCertInfo(String keyPath, String keyPassphrase, String clientCertPath, String caPath) {
        this.keyPath = keyPath;
        this.keyPassphrase = keyPassphrase;
        this.clientCertPath = clientCertPath;
        this.caPath = caPath;
    }

    public void applyTo(HttpClientConfig.Builder builder) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try (FileInputStream clientCert = new FileInputStream(new File(this.clientCertPath));
             FileInputStream key = new FileInputStream(new File(this.keyPath));
             FileInputStream certificateAuthoritiies = new FileInputStream(new File(this.caPath));){
            KeyStore keyStore = PemReader.loadKeyStore(clientCert, key, Optional.ofNullable(this.keyPassphrase));
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keyPassphrase.toCharArray());
            KeyStore trustStore = PemReader.loadTrustStore(certificateAuthoritiies);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            builder.sslSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
            builder.httpsIOSessionStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslContext, (HostnameVerifier)new NoopHostnameVerifier()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConfigurationException(configExceptionMessage, (Throwable)e);
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PEMCertInfo> {
        @PluginBuilderAttribute
        @Required(message="No keyPath provided for PEM")
        private String keyPath;
        @PluginBuilderAttribute
        @Required(message="No clientCertPath provided for PEM")
        private String clientCertPath;
        @PluginBuilderAttribute
        @Required(message="No caPath provided for PEM")
        private String caPath;
        @PluginBuilderAttribute
        @PluginAliases(value={"keyPassword"})
        private String keyPassphrase;

        public PEMCertInfo build() {
            if (this.keyPath == null) {
                throw new ConfigurationException("No keyPath provided for PEM");
            }
            if (this.clientCertPath == null) {
                throw new ConfigurationException("No clientCertPath provided for PEM");
            }
            if (this.caPath == null) {
                throw new ConfigurationException("No caPath provided for PEM");
            }
            return new PEMCertInfo(this.keyPath, this.keyPassphrase, this.clientCertPath, this.caPath);
        }

        public Builder withKeyPath(String keyPath) {
            this.keyPath = keyPath;
            return this;
        }

        public Builder withClientCertPath(String clientCertPath) {
            this.clientCertPath = clientCertPath;
            return this;
        }

        public Builder withCaPath(String caPath) {
            this.caPath = caPath;
            return this;
        }

        public Builder withKeyPassphrase(String keyPassphrase) {
            this.keyPassphrase = keyPassphrase;
            return this;
        }
    }
}

