/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.JestResult;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.jest.GenericJestRequest;

public class CheckBootstrapIndex
extends SetupStep<GenericJestRequest, JestResult> {
    protected final String rolloverAlias;

    public CheckBootstrapIndex(String rolloverAlias) {
        this.rolloverAlias = rolloverAlias;
    }

    public Result onResponse(JestResult response) {
        if (response.getResponseCode() == 404) {
            InternalLogging.getLogger().info("{}: Index {} does not exist", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.rolloverAlias});
            return Result.SUCCESS;
        }
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Index {} already exists", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.rolloverAlias});
            return Result.SKIP;
        }
        InternalLogging.getLogger().error("{}: Unable to determine if {} index already exists", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.rolloverAlias});
        return Result.FAILURE;
    }

    public GenericJestRequest createRequest() {
        return new GenericJestRequest("HEAD", null){

            @Override
            public String buildURI() {
                return CheckBootstrapIndex.this.rolloverAlias;
            }
        };
    }
}

