/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.netty.buffer.ByteBuf;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.http.JestHttpClient;
import java.io.IOException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.ByteBufEntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulk;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulkResult;
import org.appenders.log4j2.elasticsearch.jest.BufferedJestResult;

public class BufferedJestHttpClient
extends JestHttpClient {
    public <T extends JestResult> void executeAsync(Action<T> clientRequest, JestResultHandler<? super T> resultHandler) {
        HttpUriRequest request;
        try {
            request = this.prepareRequest((BufferedBulk)clientRequest);
        }
        catch (IOException e) {
            resultHandler.failed((Exception)e);
            return;
        }
        this.getAsyncClient().execute(request, this.responseHandler(clientRequest, resultHandler));
    }

    private <T extends JestResult> BufferedResultCallback<T> responseHandler(Action<T> clientRequest, JestResultHandler<? super T> resultHandler) {
        return new BufferedResultCallback<T>(clientRequest, resultHandler);
    }

    protected HttpUriRequest prepareRequest(BufferedBulk clientRequest) throws IOException {
        String requestURL = this.getRequestURL(this.getNextServer(), clientRequest.getURI());
        HttpPost httpUriRequest = new HttpPost(requestURL);
        ByteBuf byteBuf = clientRequest.serializeRequest();
        ByteBufEntityBuilder entityBuilder = (ByteBufEntityBuilder)new ByteBufEntityBuilder().setByteBuf(byteBuf).setContentLength(byteBuf.writerIndex()).setContentType(this.requestContentType);
        ((HttpEntityEnclosingRequest)httpUriRequest).setEntity(entityBuilder.build());
        return httpUriRequest;
    }

    public class BufferedResultCallback<T extends JestResult>
    implements FutureCallback<HttpResponse> {
        private final Action<T> clientRequest;
        private final JestResultHandler<T> resultHandler;

        public BufferedResultCallback(Action<T> clientRequest, JestResultHandler<T> request) {
            this.clientRequest = clientRequest;
            this.resultHandler = request;
        }

        public void completed(HttpResponse response) {
            BufferedJestResult jestResult = new BufferedJestResult();
            try {
                StatusLine statusLine = response.getStatusLine();
                BufferedBulkResult bulkResult = ((BufferedBulk)this.clientRequest).deserializeResponse(response.getEntity().getContent());
                jestResult.setSucceeded(bulkResult.isSucceeded());
                jestResult.setResponseCode(statusLine.getStatusCode());
                jestResult.setErrorMessage(bulkResult.getErrorMessage(statusLine.getReasonPhrase()));
                jestResult.setItems(bulkResult.getItems());
            }
            catch (IOException e) {
                this.failed(e);
                return;
            }
            catch (Throwable t) {
                this.failed(new Exception("Problem during request processing", t));
                return;
            }
            this.resultHandler.completed((Object)jestResult);
        }

        public void failed(Exception ex) {
            this.resultHandler.failed(ex);
        }

        public void cancelled() {
            this.resultHandler.failed(new Exception("Request cancelled"));
        }
    }
}

