/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import java.util.List;
import java.util.Optional;
import org.appenders.log4j2.elasticsearch.jest.BulkError;
import org.appenders.log4j2.elasticsearch.jest.BulkResultItem;

public class BufferedBulkResult {
    static final String NO_FAILED_ITEMS_MESSAGE = "Unable to extract error info from failed items";
    static final String ONE_OR_MORE_ITEMS_FAILED_MESSAGE = "One or more items failed";
    static final String FIRST_ERROR_ITEM_PREFIX = "First error: ";
    static final String ROOT_ERROR_ITEM_PREFIX = "Root error: ";
    static final String BULK_REQUEST_FAILED_MESAGE = "Bulk request failed";
    private static final String SEPARATOR = ". ";
    private final int took;
    private final boolean errors;
    private final BulkError error;
    private final int status;
    private final List<BulkResultItem> items;

    public BufferedBulkResult(int took, boolean errors, BulkError error, int status, List<BulkResultItem> items) {
        this.took = took;
        this.errors = errors;
        this.error = error;
        this.status = status;
        this.items = items;
    }

    public int getTook() {
        return this.took;
    }

    public boolean isSucceeded() {
        return !this.errors && this.error == null;
    }

    public BulkError getError() {
        return this.error;
    }

    public int getStatus() {
        return this.status;
    }

    public List<BulkResultItem> getItems() {
        return this.items;
    }

    String getErrorMessage(String defaultMessage) {
        if (this.isSucceeded()) {
            return defaultMessage;
        }
        StringBuilder sb = new StringBuilder(256);
        if (this.errors) {
            sb.append(ONE_OR_MORE_ITEMS_FAILED_MESSAGE);
            this.appendFailedItemErrorMessageIfAvailable(sb.append(SEPARATOR));
        } else {
            sb.append(BULK_REQUEST_FAILED_MESAGE);
        }
        if (this.getStatus() > 0) {
            sb.append(SEPARATOR).append("status: ").append(this.getStatus());
        }
        if (this.getError() != null) {
            sb.append(SEPARATOR).append(ROOT_ERROR_ITEM_PREFIX);
            this.getError().appendErrorMessage(sb);
        }
        return sb.toString();
    }

    private StringBuilder appendFailedItemErrorMessageIfAvailable(StringBuilder sb) {
        if (this.getItems() == null) {
            return sb.append(NO_FAILED_ITEMS_MESSAGE);
        }
        Optional<BulkResultItem> firstFailedItem = this.getItems().stream().filter(item -> item.getBulkError() != null).findFirst();
        if (!firstFailedItem.isPresent()) {
            return sb.append(NO_FAILED_ITEMS_MESSAGE);
        }
        sb.append(FIRST_ERROR_ITEM_PREFIX);
        return firstFailedItem.get().getBulkError().appendErrorMessage(sb);
    }
}

