/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import io.netty.buffer.ByteBuf;
import io.searchbox.action.BulkableAction;
import io.searchbox.core.Bulk;
import org.appenders.log4j2.elasticsearch.BatchBuilder;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ExtendedObjectMapper;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.JacksonMixIn;
import org.appenders.log4j2.elasticsearch.PooledItemSourceFactory;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulk;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulkResult;
import org.appenders.log4j2.elasticsearch.jest.BufferedBulkResultMixIn;
import org.appenders.log4j2.elasticsearch.jest.BufferedIndex;
import org.appenders.log4j2.elasticsearch.jest.BulkError;
import org.appenders.log4j2.elasticsearch.jest.BulkErrorMixIn;
import org.appenders.log4j2.elasticsearch.jest.BulkResultItem;
import org.appenders.log4j2.elasticsearch.jest.BulkResultItemMixIn;
import org.appenders.log4j2.elasticsearch.jest.BulkableActionMixIn;

public class BufferedBulkOperations
implements BatchOperations<Bulk> {
    public static final String DEFAULT_MAPPING_TYPE = "_doc";
    private final PooledItemSourceFactory pooledItemSourceFactory;
    private final String mappingType;
    private final JacksonMixIn[] mixIns;
    private final ObjectWriter objectWriter;
    private final ObjectReader objectReader;

    public BufferedBulkOperations(PooledItemSourceFactory pooledItemSourceFactory) {
        this(pooledItemSourceFactory, new JacksonMixIn[0], DEFAULT_MAPPING_TYPE);
    }

    public BufferedBulkOperations(PooledItemSourceFactory pooledItemSourceFactory, JacksonMixIn[] mixIns, String mappingType) {
        this.pooledItemSourceFactory = pooledItemSourceFactory;
        this.mappingType = mappingType;
        this.mixIns = mixIns;
        this.objectWriter = this.configuredWriter();
        this.objectReader = this.configuredReader();
    }

    public Object createBatchItem(String indexName, Object source) {
        throw new UnsupportedOperationException("Use ItemSource based API instead");
    }

    public Object createBatchItem(String indexName, ItemSource source) {
        return ((BufferedIndex.Builder)((Object)((BufferedIndex.Builder)((Object)new BufferedIndex.Builder((ItemSource<ByteBuf>)source).index(indexName))).type(this.mappingType))).build();
    }

    public BatchBuilder<Bulk> createBatchBuilder() {
        return new BatchBuilder<Bulk>(){
            private final BufferedBulk.Builder builder;
            {
                this.builder = new BufferedBulk.Builder().withBuffer((ItemSource<ByteBuf>)BufferedBulkOperations.this.pooledItemSourceFactory.createEmptySource()).withObjectWriter(BufferedBulkOperations.this.objectWriter).withObjectReader(BufferedBulkOperations.this.objectReader);
            }

            public void add(Object item) {
                this.builder.addAction((BulkableAction)item);
            }

            public Bulk build() {
                return this.builder.build();
            }
        };
    }

    protected ObjectWriter configuredWriter() {
        ObjectMapper objectMapper = new ExtendedObjectMapper(new JsonFactory()).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.CLOSE_CLOSEABLE, false).addMixIn(BufferedIndex.class, BulkableActionMixIn.class);
        for (JacksonMixIn mixIn : this.mixIns) {
            objectMapper.addMixIn(mixIn.getTargetClass(), mixIn.getMixInClass());
        }
        return objectMapper.writerFor(BufferedIndex.class);
    }

    protected ObjectReader configuredReader() {
        return new ObjectMapper().setVisibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().with(JsonAutoDetect.Visibility.ANY)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.CLOSE_CLOSEABLE, false).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true).addMixIn(BufferedBulkResult.class, BufferedBulkResultMixIn.class).addMixIn(BulkError.class, BulkErrorMixIn.class).addMixIn(BulkResultItem.class, BulkResultItemMixIn.class).readerFor(BufferedBulkResult.class);
    }
}

