/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.jest;

import io.searchbox.client.config.HttpClientConfig;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.log4j2.elasticsearch.Credentials;

@Plugin(name="BasicCredentials", category="Core", elementType="credentials")
public final class BasicCredentials
implements Credentials<HttpClientConfig.Builder> {
    static final String PLUGIN_NAME = "BasicCredentials";
    private final String username;
    private final String password;

    protected BasicCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void applyTo(HttpClientConfig.Builder builder) {
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(this.username, this.password));
        builder.credentialsProvider((CredentialsProvider)basicCredentialsProvider);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<BasicCredentials> {
        @PluginBuilderAttribute
        @Required(message="No username provided for BasicCredentials")
        private String username;
        @PluginBuilderAttribute
        @Required(message="No password provided for BasicCredentials")
        private String password;

        public BasicCredentials build() {
            if (this.username == null) {
                throw new ConfigurationException("No username provided for BasicCredentials");
            }
            if (this.password == null) {
                throw new ConfigurationException("No password provided for BasicCredentials");
            }
            return new BasicCredentials(this.username, this.password);
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }
    }
}

