/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

public class ByteBufHttpEntity
extends AbstractHttpEntity {
    private final ByteBuf content;
    private final long length;

    public ByteBufHttpEntity(ByteBuf byteBuf, long length, ContentType contentType) {
        this.content = (ByteBuf)Args.notNull((Object)byteBuf, (String)"Source input stream");
        this.length = length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() {
        return new ByteBufInputStream(this.content){

            public void close() throws IOException {
                super.close();
                ByteBufHttpEntity.this.content.readerIndex(0);
            }
        };
    }

    public void writeTo(OutputStream outstream) {
        throw new UnsupportedOperationException("writeTo(OutputStream) is not supported. Use getContent() to get InputStream instead");
    }
}

