/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.test.mock;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.wink.test.diff.DiffIgnoreUpdateWithAttributeQualifier;
import org.apache.wink.test.mock.SpringMockServletInvocationTest;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    public static String packageToPath(String packageName) {
        return packageName.replace(".", File.separator);
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    public static InputStream getResourceOfSamePackage(String name, Class<?> cls) {
        String packagePath = TestUtils.packageToPath(cls.getPackage().getName());
        return SpringMockServletInvocationTest.class.getClassLoader().getResourceAsStream(packagePath + File.separator + name);
    }

    public static byte[] getResourceOfSamePackageAsBytes(String name, Class<?> cls) throws Exception {
        InputStream resource = TestUtils.getResourceOfSamePackage(name, cls);
        byte[] b = new byte[4096];
        int read = resource.read(b);
        byte[] result = new byte[read];
        System.arraycopy(b, 0, result, 0, read);
        return result;
    }

    protected static Document getXML(String fileName, Class<?> cls) throws Exception {
        return TestUtils.createDocumentBuilder().parse(TestUtils.getResourceOfSamePackage(fileName, cls));
    }

    public static Document getXML(byte[] bs) throws Exception {
        return TestUtils.createDocumentBuilder().parse(new ByteArrayInputStream(bs));
    }

    public static String diffIgnoreUpdateWithAttributeQualifier(String expectedFileName, byte[] actual, Class<?> cls) throws Exception {
        Document xmlActual;
        Document xmlExpected = TestUtils.getXML(expectedFileName, cls);
        DiffIgnoreUpdateWithAttributeQualifier diff = new DiffIgnoreUpdateWithAttributeQualifier(xmlExpected, xmlActual = TestUtils.getXML(actual));
        if (diff.similar()) {
            return null;
        }
        System.err.println("Expected:\r\n" + TestUtils.printPrettyXML(xmlExpected));
        System.err.println("Actual:\r\n" + TestUtils.printPrettyXML(xmlActual));
        return diff.toString();
    }

    public static String diffIgnoreUpdateWithAttributeQualifier(String expected, String actual) throws Exception {
        return TestUtils.diffIgnoreUpdateWithAttributeQualifier(expected.getBytes("UTF-8"), actual.getBytes("UTF-8"));
    }

    public static String diffIgnoreUpdateWithAttributeQualifier(byte[] expected, byte[] actual) throws Exception {
        Document xmlActual;
        Document xmlExpected = TestUtils.getXML(expected);
        DiffIgnoreUpdateWithAttributeQualifier diff = new DiffIgnoreUpdateWithAttributeQualifier(xmlExpected, xmlActual = TestUtils.getXML(actual));
        if (diff.similar()) {
            return null;
        }
        System.err.println("Expected:\r\n" + TestUtils.printPrettyXML(xmlExpected));
        System.err.println("Actual:\r\n" + TestUtils.printPrettyXML(xmlActual));
        return diff.toString();
    }

    public static String printPrettyXML(Document doc) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        StringWriter output = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(output));
        return output.toString();
    }
}

