/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.test.diff;

import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.wink.test.diff.DifferenceListenerIgnoreWhitespace;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.NodeDetail;
import org.w3c.dom.Node;

public class DifferenceListenerIgnoreUpdateOrCompareTimes
extends DifferenceListenerIgnoreWhitespace {
    private Set<String> timeNodeNameSet = new HashSet<String>();

    public DifferenceListenerIgnoreUpdateOrCompareTimes() {
        String[] names;
        for (String name : names = new String[]{"updated", "published", "atom:updated", "atom:published", "stm:created", "created", "stm:closed", "closed"}) {
            this.timeNodeNameSet.add(name);
        }
    }

    public int differenceFound(Difference difference) {
        String testNodeName;
        int result = super.differenceFound(difference);
        if (result != 0) {
            return result;
        }
        String xpath = difference.getTestNodeDetail().getXpathLocation();
        if (xpath.equals("/feed[1]/updated[1]/text()[1]")) {
            return 1;
        }
        NodeDetail testDetail = difference.getTestNodeDetail();
        if (testDetail.getNode().getParentNode() != null && this.timeNodeNameSet.contains(testNodeName = testDetail.getNode().getParentNode().getNodeName())) {
            DatatypeFactory datatypeFactory;
            String testDateStr = testDetail.getValue();
            String controlDateStr = difference.getControlNodeDetail().getValue();
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
            XMLGregorianCalendar test = datatypeFactory.newXMLGregorianCalendar(testDateStr);
            XMLGregorianCalendar control = datatypeFactory.newXMLGregorianCalendar(controlDateStr);
            if (TimeZone.getDefault().useDaylightTime() && TimeZone.getDefault().getRawOffset() == 0) {
                test.setTimezone(60);
            }
            if (test.compare(control) == 0) {
                return 1;
            }
        }
        return 0;
    }

    public void skippedComparison(Node node, Node node1) {
    }
}

