/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.image.resource;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.WebResource;
import org.apache.wicket.markup.html.image.resource.DynamicImageResource;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ThumbnailImageResource.class);
    private final WebResource unscaledImageResource;
    private final int maxSize;
    private int scaleHints = 4;
    private transient byte[] thumbnail;

    public ThumbnailImageResource(WebResource unscaledImageResource, int maxSize) {
        if (unscaledImageResource == null) {
            throw new IllegalArgumentException("Argument unscaledImageResource must be not null");
        }
        this.unscaledImageResource = unscaledImageResource;
        this.maxSize = maxSize;
    }

    protected byte[] getImageData() {
        if (this.thumbnail == null) {
            BufferedImage image = this.getScaledImageInstance();
            this.thumbnail = this.toImageData(image);
            this.setLastModifiedTime(Time.now());
        }
        return this.thumbnail;
    }

    protected final BufferedImage getScaledImageInstance() {
        InputStream is = null;
        BufferedImage originalImage = null;
        try {
            is = this.unscaledImageResource.getResourceStream().getInputStream();
            originalImage = ImageIO.read(is);
            if (originalImage == null) {
                throw new IOException("unable to read image");
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (ResourceStreamNotFoundException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        int originalWidth = originalImage.getWidth();
        int originalHeight = originalImage.getHeight();
        if (originalWidth > this.maxSize || originalHeight > this.maxSize) {
            int newHeight;
            int newWidth;
            if (originalWidth > originalHeight) {
                newWidth = this.maxSize;
                newHeight = this.maxSize * originalHeight / originalWidth;
            } else {
                newWidth = this.maxSize * originalWidth / originalHeight;
                newHeight = this.maxSize;
            }
            Image image = originalImage.getScaledInstance(newWidth, newHeight, this.scaleHints);
            BufferedImage bufferedImage = new BufferedImage(newWidth, newHeight, 2);
            bufferedImage.createGraphics().drawImage(image, 0, 0, null);
            return bufferedImage;
        }
        return originalImage;
    }

    public final synchronized void setScaleHints(int scaleHints) {
        this.scaleHints = scaleHints;
        this.invalidate();
    }

    public synchronized void invalidate() {
        this.thumbnail = null;
    }
}

