/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IInitializer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.WicketAjaxReference;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.MultipartRequest;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadStatusResource;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadWebRequest;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.JavascriptPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadProgressBar
extends Panel
implements IHeaderContributor {
    private static final Logger log = LoggerFactory.getLogger(UploadProgressBar.class);
    private static final ResourceReference JS = new ResourceReference(UploadProgressBar.class, "progressbar.js");
    private static final ResourceReference CSS = new ResourceReference(UploadProgressBar.class, "UploadProgressBar.css");
    private static final String RESOURCE_NAME = UploadProgressBar.class.getName();
    private static final long serialVersionUID = 1L;
    private final Form<?> form;
    private final WebMarkupContainer statusDiv;
    private final WebMarkupContainer barDiv;
    private final FileUploadField uploadField;

    public UploadProgressBar(String id, Form<?> form) {
        this(id, form, null);
    }

    public UploadProgressBar(String id, Form<?> form, FileUploadField fileUploadField) {
        super(id);
        this.uploadField = fileUploadField;
        this.form = form;
        this.setRenderBodyOnly(true);
        this.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution((ResourceReference)WicketEventReference.INSTANCE)});
        this.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution((ResourceReference)WicketAjaxReference.INSTANCE)});
        this.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution((ResourceReference)JS)});
        ResourceReference css = this.getCss();
        if (css != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)css)});
        }
        this.barDiv = new WebMarkupContainer("bar");
        this.barDiv.setOutputMarkupId(true);
        this.add(new Component[]{this.barDiv});
        this.statusDiv = new WebMarkupContainer("status");
        this.statusDiv.setOutputMarkupId(true);
        this.add(new Component[]{this.statusDiv});
        if (!(RequestCycle.get().getRequest() instanceof UploadWebRequest) && !(RequestCycle.get().getRequest() instanceof MultipartRequest)) {
            log.warn("UploadProgressBar will not work without an UploadWebRequest. See the javadoc for details.");
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        this.getCallbackForm().setOutputMarkupId(true);
    }

    protected ResourceReference getCss() {
        return CSS;
    }

    public void renderHead(IHeaderResponse response) {
        ResourceReference ref = new ResourceReference(RESOURCE_NAME);
        String uploadFieldId = this.uploadField == null ? "" : this.uploadField.getMarkupId();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream js = new PrintStream(out);
        js.printf("  var def=new Wicket.WUPB.Def('%s', '%s', '%s', '%s','%s');", this.getMarkupId(), this.statusDiv.getMarkupId(), this.barDiv.getMarkupId(), this.urlFor(ref), uploadFieldId);
        js.printf(" new Wicket.WUPB(def).bind('%s');", this.getCallbackForm().getMarkupId());
        response.renderOnDomReadyJavascript(new String(out.toByteArray()));
    }

    private Form<?> getCallbackForm() {
        final Model insideModal = new Model((Serializable)Boolean.valueOf(false));
        this.form.visitParents(ModalWindow.class, (Component.IVisitor)new Component.IVisitor<Component>(){

            public Object component(Component component) {
                insideModal.setObject((Serializable)Boolean.valueOf(true));
                return Component.IVisitor.STOP_TRAVERSAL;
            }
        });
        if (((Boolean)insideModal.getObject()).booleanValue()) {
            return this.form;
        }
        return this.form.getRootForm();
    }

    public static final class ComponentInitializer
    implements IInitializer {
        public void init(Application application) {
            Application.get().getSharedResources().add(RESOURCE_NAME, (Resource)new UploadStatusResource());
        }

        public String toString() {
            return "Ajax UploadProgressBar initializer";
        }
    }
}

