/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell.jline;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jline.SimpleCompletor;
import org.apache.tuscany.sca.shell.Shell;
import org.apache.tuscany.sca.shell.jline.TShellCompletor;
import org.oasisopen.sca.NoSuchServiceException;

public class ServiceOperationCompletor
extends SimpleCompletor {
    private Shell shell;
    private static final List<String> EXCLUDED_OPS = Arrays.asList("equals", "getClass", "getInvocationHandler", "getProxyClass", "hashCode", "isProxyClass", "newProxyInstance", "notify", "notifyAll", "toString", "wait", "CGLIB$SET_STATIC_CALLBACKS", "CGLIB$SET_THREAD_CALLBACKS", "CGLIB$findMethodProxy", "getCallback", "getCallbacks", "newInstance", "setCallback", "setCallbacks");

    public ServiceOperationCompletor(Shell shell) {
        super("");
        this.shell = shell;
    }

    public int complete(String buffer, int cursor, List clist) {
        String service = TShellCompletor.lastArg;
        try {
            Object proxy = this.shell.getNode().getService(null, service);
            Method[] ms = proxy.getClass().getMethods();
            ArrayList<String> ops = new ArrayList<String>();
            for (Method m : ms) {
                if (EXCLUDED_OPS.contains(m.getName())) continue;
                ops.add(m.getName());
            }
            this.setCandidateStrings(ops.toArray(new String[ops.size()]));
        }
        catch (NoSuchServiceException e) {
            // empty catch block
        }
        return super.complete(buffer, cursor, clist);
    }
}

