/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell.commands;

import jline.Completor;
import jline.NullCompletor;
import org.apache.tuscany.sca.shell.Command;
import org.apache.tuscany.sca.shell.Shell;
import org.apache.tuscany.sca.shell.jline.CompositeURICompletor;
import org.apache.tuscany.sca.shell.jline.ICURICompletor;

public class Stop
implements Command {
    private Shell shell;

    public Stop(Shell shell) {
        this.shell = shell;
    }

    @Override
    public String getName() {
        return "stop";
    }

    @Override
    public String getShortHelp() {
        return "stop <curi> <compositeUri>";
    }

    @Override
    public String getHelp() {
        StringBuilder helpText = new StringBuilder();
        helpText.append("   Stop a composite.\n");
        helpText.append("\n");
        helpText.append("   The composite is removed from the domain composite, along with all the components, wires,\n");
        helpText.append("   services and references originally added when the composite was started.\n");
        helpText.append("\n");
        helpText.append("   Arguments:\n");
        helpText.append("      curi         - (required) the URI of an installed contribution\n");
        helpText.append("      compositeUri - (required) the URI of a composite within the contribution to stop\n");
        return helpText.toString();
    }

    @Override
    public Completor[] getCompletors() {
        return new Completor[]{new ICURICompletor(this.shell), new CompositeURICompletor(this.shell), new NullCompletor()};
    }

    @Override
    public boolean invoke(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Wrong number of args");
            System.err.println(this.getShortHelp());
            return true;
        }
        this.shell.getNode().stopComposite(args[0], args[1]);
        return true;
    }
}

