/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell.commands;

import jline.Completor;
import jline.NullCompletor;
import org.apache.tuscany.sca.shell.Command;
import org.apache.tuscany.sca.shell.Shell;
import org.apache.tuscany.sca.shell.jline.CompositeURICompletor;
import org.apache.tuscany.sca.shell.jline.ICURICompletor;
import org.apache.tuscany.sca.shell.jline.RemoteNodeCompletor;

public class Start
implements Command {
    private Shell shell;

    public Start(Shell shell) {
        this.shell = shell;
    }

    @Override
    public String getName() {
        return "start";
    }

    @Override
    public String getShortHelp() {
        return "start <curi> <compositeUri> [<remoteNode>]";
    }

    @Override
    public String getHelp() {
        StringBuilder helpText = new StringBuilder();
        helpText.append("   Start a composite.\n");
        helpText.append("\n");
        helpText.append("   The composite is added to the domain composite with semantics that correspond to the domain-level\n");
        helpText.append("   composite having an <include> statement that references the supplied composite. All of the composite's\n");
        helpText.append("   components become top-level components and the component services become externally visible\n");
        helpText.append("   services (eg. they would be present in a WSDL description of the Domain).\n");
        helpText.append("\n");
        helpText.append("   Arguments:\n");
        helpText.append("      curi         - (required) the URI of an installed contribution\n");
        helpText.append("      compositeUri - (required) the URI of a composite within the contribution to start\n");
        helpText.append("      remoteNode   - (optional) the name of a remote node which should run the composite\n");
        return helpText.toString();
    }

    @Override
    public Completor[] getCompletors() {
        return new Completor[]{new ICURICompletor(this.shell), new CompositeURICompletor(this.shell), new RemoteNodeCompletor(this.shell), new NullCompletor()};
    }

    @Override
    public boolean invoke(String[] args) throws Exception {
        if (args.length == 2) {
            this.shell.getNode().startComposite(args[0], args[1]);
        } else if (args.length == 3) {
            this.shell.getNode().startComposite(args[0], args[1], args[2]);
        } else {
            System.err.println("Wrong number of args");
            System.err.println(this.getShortHelp());
            return true;
        }
        return true;
    }
}

