/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tuscany.sca.common.xml.xpath.XPathHelper;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentMap;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.Qualifier;
import org.apache.tuscany.sca.policy.xml.PolicyConstants;
import org.apache.tuscany.sca.policy.xml.PolicyXPathFunction;
import org.apache.tuscany.sca.policy.xml.PolicyXPathFunctionResolver;

public class PolicySetProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<PolicySet>,
PolicyConstants {
    private PolicyFactory policyFactory;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private XPathHelper xpathHelper;

    public PolicySetProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor<Object> extensionProcessor) {
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.xpathHelper = XPathHelper.getInstance(registry);
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public PolicySet read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String attachTo;
        PolicySet policySet = null;
        Monitor monitor = context.getMonitor();
        String policySetName = reader.getAttributeValue(null, "name");
        String appliesTo = reader.getAttributeValue(null, "appliesTo");
        if (policySetName == null || appliesTo == null) {
            if (policySetName == null) {
                this.error(monitor, "PolicySetNameMissing", (Object)reader, new Object[0]);
            }
            if (appliesTo == null) {
                this.error(monitor, "PolicySetAppliesToMissing", (Object)reader, new Object[0]);
            }
            return policySet;
        }
        policySet = this.policyFactory.createPolicySet();
        policySet.setName(new QName(policySetName));
        if (appliesTo != null && !appliesTo.startsWith("/")) {
            appliesTo = "//" + appliesTo;
        }
        policySet.setAppliesTo(appliesTo);
        if (appliesTo != null) {
            try {
                XPath path = this.xpathHelper.newXPath();
                NamespaceContext nsContext = this.xpathHelper.getNamespaceContext(appliesTo, reader.getNamespaceContext());
                XPathExpression expression = this.xpathHelper.compile(path, nsContext, appliesTo);
                policySet.setAppliesToXPathExpression(expression);
            }
            catch (XPathExpressionException e) {
                ContributionReadException ce = new ContributionReadException(e);
                this.error(monitor, "ContributionReadException", (Object)policySet, ce);
            }
        }
        if ((attachTo = reader.getAttributeValue(null, "attachTo")) != null) {
            try {
                XPath path = this.xpathHelper.newXPath();
                NamespaceContext nsContext = this.xpathHelper.getNamespaceContext(attachTo, reader.getNamespaceContext());
                path.setXPathFunctionResolver(new PolicyXPathFunctionResolver(nsContext));
                attachTo = PolicyXPathFunction.normalize(attachTo, this.getSCAPrefix(nsContext));
                XPathExpression expression = this.xpathHelper.compile(path, nsContext, attachTo);
                policySet.setAttachTo(attachTo);
                policySet.setAttachToXPathExpression(expression);
            }
            catch (XPathExpressionException e) {
                ContributionReadException ce = new ContributionReadException(e);
                this.error(monitor, "ContributionReadException", (Object)policySet, ce);
            }
        }
        this.readProvidedIntents(policySet, reader);
        int event = reader.getEventType();
        QName name = null;
        reader.next();
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (POLICY_INTENT_MAP_QNAME.equals(name)) {
                        Intent mappedIntent = this.policyFactory.createIntent();
                        String provides = reader.getAttributeValue(null, "provides");
                        if (provides != null) {
                            mappedIntent.setName(this.getQName(reader, "provides"));
                            if (policySet.getProvidedIntents().contains(mappedIntent)) {
                                this.readIntentMap(reader, policySet, mappedIntent, context);
                                break;
                            }
                            this.error(monitor, "IntentNotSpecified", (Object)policySet, policySetName);
                            break;
                        }
                        this.error(monitor, "IntentMapProvidesMissing", (Object)reader, policySetName);
                        break;
                    }
                    if (POLICY_SET_REFERENCE_QNAME.equals(name)) {
                        PolicySet referredPolicySet = this.policyFactory.createPolicySet();
                        String referencename = reader.getAttributeValue(null, "name");
                        if (referencename != null) {
                            referredPolicySet.setName(this.getQName(reader, "name"));
                            policySet.getReferencedPolicySets().add(referredPolicySet);
                            break;
                        }
                        this.error(monitor, "PolicySetReferenceNameMissing", (Object)reader, policySetName);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader, context);
                    if (extension == null) break;
                    PolicyExpression exp = this.policyFactory.createPolicyExpression();
                    exp.setName(name);
                    exp.setPolicy(extension);
                    if (policySet.getPolicies().size() > 0 && !policySet.getPolicies().get(0).getName().getNamespaceURI().equals(name.getNamespaceURI())) {
                        this.error(monitor, "PolicyLanguageMissmatch", (Object)reader, policySet.getName(), policySet.getPolicies().get(0).getName(), name);
                        break;
                    }
                    policySet.getPolicies().add(exp);
                }
            }
            if (event == 2 && POLICY_SET_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policySet;
    }

    private String getSCAPrefix(NamespaceContext nsContext) {
        Iterator<String> iter = nsContext.getPrefixes("http://docs.oasis-open.org/ns/opencsa/sca/200912");
        while (iter.hasNext()) {
            String prefix = iter.next();
            if (prefix.equals("")) continue;
            return prefix;
        }
        return "__sca";
    }

    public void readIntentMap(XMLStreamReader reader, PolicySet policySet, Intent mappedIntent, ProcessorContext context) throws ContributionReadException {
        Monitor monitor = context.getMonitor();
        QName name = reader.getName();
        if (POLICY_INTENT_MAP_QNAME.equals(name)) {
            IntentMap intentMap = this.policyFactory.createIntentMap();
            QName intentName = this.getQName(reader, "intentMap");
            intentMap.setProvidedIntent(mappedIntent);
            if (!policySet.getIntentMaps().contains(intentMap)) {
                policySet.getIntentMaps().add(intentMap);
            } else {
                Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", "IntentMapIsNotUnique", policySet.getName().toString(), mappedIntent.getName().getLocalPart());
            }
            String qualifierName = null;
            String qualfiedIntentName = null;
            Intent qualifiedIntent = null;
            Qualifier qualifier = null;
            int event = reader.getEventType();
            try {
                reader.next();
                while (reader.hasNext()) {
                    event = reader.getEventType();
                    switch (event) {
                        case 1: {
                            name = reader.getName();
                            if (POLICY_INTENT_MAP_QUALIFIER_QNAME.equals(name)) {
                                qualifierName = this.getString(reader, "name");
                                if (qualifierName != null) {
                                    qualfiedIntentName = mappedIntent.getName().getLocalPart() + "." + qualifierName;
                                    qualifiedIntent = this.policyFactory.createIntent();
                                    qualifiedIntent.setName(new QName(mappedIntent.getName().getNamespaceURI(), qualfiedIntentName));
                                    qualifier = this.policyFactory.createQualifier();
                                    qualifier.setIntent(qualifiedIntent);
                                    intentMap.getQualifiers().add(qualifier);
                                    break;
                                }
                                this.error(monitor, "QualifierNameMissing", (Object)reader, policySet.getName());
                                break;
                            }
                            if (POLICY_INTENT_MAP_QNAME.equals(name)) {
                                QName providedIntent = this.getQName(reader, "provides");
                                if (qualifierName.equals(providedIntent.getLocalPart())) {
                                    this.readIntentMap(reader, policySet, qualifiedIntent, context);
                                    break;
                                }
                                this.error(monitor, "IntentMapDoesNotMatch", (Object)providedIntent, providedIntent, qualifierName, policySet);
                                break;
                            }
                            Object extension = this.extensionProcessor.read(reader, context);
                            if (extension == null || qualifier == null) break;
                            PolicyExpression exp = this.policyFactory.createPolicyExpression();
                            exp.setName(name);
                            exp.setPolicy(extension);
                            qualifier.getPolicies().add(exp);
                        }
                    }
                    if (event != 2 || !POLICY_INTENT_MAP_QNAME.equals(reader.getName())) {
                        if (!reader.hasNext()) continue;
                        reader.next();
                        continue;
                    }
                    break;
                }
            }
            catch (XMLStreamException e) {
                ContributionReadException ce = new ContributionReadException(e);
                this.error(monitor, "ContributionReadException", (Object)reader, ce);
                throw ce;
            }
        }
    }

    @Override
    public void write(PolicySet policySet, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "policySet");
        writer.writeNamespace(policySet.getName().getPrefix(), policySet.getName().getNamespaceURI());
        writer.writeAttribute("name", policySet.getName().getPrefix() + ":" + policySet.getName().getLocalPart());
        if (policySet.getAppliesTo() != null) {
            writer.writeAttribute("appliesTo", policySet.getAppliesTo());
        }
        if (policySet.getAttachTo() != null) {
            writer.writeAttribute("attachTo", policySet.getAttachTo());
        }
        this.writeProvidedIntents(policySet, writer);
        writer.writeEndElement();
    }

    private void readProvidedIntents(PolicySet policySet, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "provides");
        if (value != null) {
            List<Intent> providedIntents = policySet.getProvidedIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                providedIntents.add(intent);
            }
        }
    }

    private void writeProvidedIntents(PolicySet policySet, XMLStreamWriter writer) throws XMLStreamException {
        if (!policySet.getProvidedIntents().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Intent providedIntents : policySet.getProvidedIntents()) {
                sb.append(this.getQualifiedName(providedIntents.getName(), writer));
                sb.append(" ");
            }
            sb.deleteCharAt(sb.length() - 1);
            writer.writeAttribute("provides", sb.toString());
        }
    }

    private String getQualifiedName(QName name, XMLStreamWriter writer) throws XMLStreamException {
        String local = name.getLocalPart();
        String prefix = writer.getPrefix(name.getNamespaceURI());
        if (prefix != null && prefix.length() > 0) {
            return prefix + ':' + local;
        }
        return local;
    }

    private void resolvePolicies(PolicySet policySet, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        boolean unresolved = false;
        if (policySet != null) {
            for (PolicyExpression o : policySet.getPolicies()) {
                this.extensionProcessor.resolve(o, resolver, context);
            }
            policySet.setUnresolved(unresolved);
        }
    }

    @Override
    public QName getArtifactType() {
        return POLICY_SET_QNAME;
    }

    @Override
    public Class<PolicySet> getModelType() {
        return PolicySet.class;
    }

    private void resolveProvidedIntents(PolicySet policySet, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (policySet != null) {
            ArrayList<Intent> providedIntents = new ArrayList<Intent>();
            for (Intent providedIntent : policySet.getProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolved = resolver.resolveModel(Intent.class, providedIntent, context);
                    if (!resolved.isUnresolved() || resolved != providedIntent) {
                        providedIntents.add(resolved);
                        continue;
                    }
                    this.error(context.getMonitor(), "ProvidedIntentNotFound", (Object)policySet, providedIntent, policySet);
                    return;
                }
                providedIntents.add(providedIntent);
            }
            policySet.getProvidedIntents().clear();
            policySet.getProvidedIntents().addAll(providedIntents);
        }
    }

    private void resolveIntentsInMappedPolicies(PolicySet policySet, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        Monitor monitor = context.getMonitor();
        for (IntentMap intentMap : policySet.getIntentMaps()) {
            Intent intent = intentMap.getProvidedIntent();
            if (intent.isUnresolved()) {
                Intent resolved = resolver.resolveModel(Intent.class, intent, context);
                if (!resolved.isUnresolved() || resolved != intent) {
                    intentMap.setProvidedIntent(resolved);
                } else {
                    this.error(monitor, "MappedIntentNotFound", (Object)policySet, intent, policySet);
                    return;
                }
            }
            for (Qualifier qualifier : intentMap.getQualifiers()) {
                intent = qualifier.getIntent();
                if (intent.isUnresolved()) {
                    Intent resolved = resolver.resolveModel(Intent.class, intent, context);
                    if (!resolved.isUnresolved() || resolved != intent) {
                        qualifier.setIntent(resolved);
                    } else {
                        this.error(monitor, "MappedIntentNotFound", (Object)policySet, intent, policySet);
                        return;
                    }
                }
                for (PolicyExpression exp : qualifier.getPolicies()) {
                }
            }
            Intent providedIntent = intentMap.getProvidedIntent();
            if (intentMap.getQualifiers().size() == providedIntent.getQualifiedIntents().size()) continue;
            String missingQualifiers = "";
            for (Intent loopQualifiedIntent : providedIntent.getQualifiedIntents()) {
                boolean found = false;
                for (Qualifier loopQualifier : intentMap.getQualifiers()) {
                    if (!loopQualifier.getIntent().getName().equals(loopQualifiedIntent.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missingQualifiers = missingQualifiers + loopQualifiedIntent.getName().getLocalPart() + " ";
            }
            if (missingQualifiers.length() <= 0) continue;
            Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", "IntentMapMissingQualifiers", policySet.getName().toString(), providedIntent.getName().getLocalPart(), missingQualifiers);
        }
    }

    private void resolveReferredPolicySets(PolicySet policySet, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        ArrayList<PolicySet> referredPolicySets = new ArrayList<PolicySet>();
        for (PolicySet referredPolicySet : policySet.getReferencedPolicySets()) {
            if (referredPolicySet.isUnresolved()) {
                PolicySet resolved = resolver.resolveModel(PolicySet.class, referredPolicySet, context);
                if (!resolved.isUnresolved() || resolved != referredPolicySet) {
                    referredPolicySets.add(resolved);
                    continue;
                }
                this.error(context.getMonitor(), "ReferredPolicySetNotFound", (Object)policySet, referredPolicySet, policySet);
                return;
            }
            referredPolicySets.add(referredPolicySet);
        }
        policySet.getReferencedPolicySets().clear();
        policySet.getReferencedPolicySets().addAll(referredPolicySets);
    }

    private void includeReferredPolicySets(PolicySet policySet, PolicySet referredPolicySet) {
        for (PolicySet furtherReferredPolicySet : referredPolicySet.getReferencedPolicySets()) {
            this.includeReferredPolicySets(referredPolicySet, furtherReferredPolicySet);
        }
        policySet.getPolicies().addAll(referredPolicySet.getPolicies());
        policySet.getIntentMaps().addAll(referredPolicySet.getIntentMaps());
    }

    @Override
    public void resolve(PolicySet policySet, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (policySet != null && policySet.isUnresolved()) {
            this.resolveProvidedIntents(policySet, resolver, context);
            this.resolveIntentsInMappedPolicies(policySet, resolver, context);
            this.resolveReferredPolicySets(policySet, resolver, context);
            for (PolicySet referredPolicySet : policySet.getReferencedPolicySets()) {
                this.includeReferredPolicySets(policySet, referredPolicySet);
            }
            if (policySet.isUnresolved()) {
                this.resolvePolicies(policySet, resolver, context);
            }
            policySet.setUnresolved(false);
        }
    }
}

