/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.jaas;

import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.security.jaas.JaasAuthenticationPolicy;
import org.oasisopen.sca.ServiceRuntimeException;

public class JaasAuthenticationInterceptor
implements PhasedInterceptor {
    private List<JaasAuthenticationPolicy> authenticationPolicies;
    private Invoker next;

    public JaasAuthenticationInterceptor(List<JaasAuthenticationPolicy> authenticationPolicies) {
        this.authenticationPolicies = authenticationPolicies;
    }

    @Override
    public Invoker getNext() {
        return this.next;
    }

    @Override
    public void setNext(Invoker next) {
        this.next = next;
    }

    @Override
    public Message invoke(Message msg) {
        try {
            for (JaasAuthenticationPolicy policy : this.authenticationPolicies) {
                CallbackHandler callbackHandler = (CallbackHandler)policy.getCallbackHandlerClass().newInstance();
                LoginContext lc = new LoginContext(policy.getConfigurationName(), callbackHandler);
                lc.login();
            }
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        return this.getNext().invoke(msg);
    }

    @Override
    public String getPhase() {
        return "implementation.policy";
    }
}

