/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.configuration.impl;

import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.node.configuration.BindingConfiguration;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.configuration.impl.BindingConfigurationImpl;
import org.apache.tuscany.sca.node.configuration.impl.ContributionConfigurationImpl;

public class NodeConfigurationImpl
implements NodeConfiguration {
    private String uri = "http://tuscany.apache.org/sca/1.1/nodes/default";
    private String domainURI = "default";
    private String domainRegistryURI = "default";
    private List<ContributionConfiguration> contributions = new ArrayList<ContributionConfiguration>();
    private List<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
    private List<Object> extensions = new ArrayList<Object>();
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private transient Map<String, Object> attributes = new HashMap<String, Object>();

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public NodeConfiguration setURI(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String getDomainURI() {
        return this.domainURI;
    }

    @Override
    public NodeConfiguration setDomainURI(String domainURI) {
        this.domainURI = domainURI;
        return this;
    }

    @Override
    public List<ContributionConfiguration> getContributions() {
        return this.contributions;
    }

    @Override
    public List<BindingConfiguration> getBindings() {
        return this.bindings;
    }

    @Override
    public NodeConfiguration addBinding(BindingConfiguration bindingConfiguration) {
        for (BindingConfiguration bc : this.bindings) {
            if (!bc.getBindingType().equals(bindingConfiguration.getBindingType())) continue;
            bc.getBaseURIs().addAll(bindingConfiguration.getBaseURIs());
            return this;
        }
        this.bindings.add(bindingConfiguration);
        return this;
    }

    @Override
    public NodeConfiguration addContribution(ContributionConfiguration contributionConfiguration) {
        this.contributions.add(contributionConfiguration);
        return this;
    }

    @Override
    public NodeConfiguration addBinding(QName bindingType, String ... baseURIs) {
        BindingConfiguration binding = new BindingConfigurationImpl().setBindingType(bindingType);
        for (String u : baseURIs) {
            String[] uris;
            for (String uri : uris = u.split("(\\s)+")) {
                if (uri.length() <= 0) continue;
                binding.addBaseURI(uri);
            }
        }
        return this.addBinding(binding);
    }

    @Override
    public NodeConfiguration addBinding(QName bindingType, URI ... baseURIs) {
        BindingConfiguration binding = new BindingConfigurationImpl().setBindingType(bindingType);
        for (URI u : baseURIs) {
            binding.addBaseURI(u.toString());
        }
        return this.addBinding(binding);
    }

    @Override
    public NodeConfiguration addContribution(String contributionURI, String location) {
        ContributionConfigurationImpl contribution = new ContributionConfigurationImpl(contributionURI, location);
        return this.addContribution(contribution);
    }

    @Override
    public NodeConfiguration addContribution(String contributionURI, URL location) {
        String url = null;
        if (location != null) {
            url = location.toString();
        }
        return this.addContribution(contributionURI, url);
    }

    @Override
    public NodeConfiguration addContribution(URI contributionURI, URL location) {
        String url = null;
        if (location != null) {
            url = location.toString();
        }
        return this.addContribution(contributionURI.toString(), url);
    }

    @Override
    public NodeConfiguration addContribution(URL ... locations) {
        for (URL url : locations) {
            ContributionConfigurationImpl contribution = new ContributionConfigurationImpl(url.toString(), url.toString());
            this.addContribution(contribution);
        }
        return this;
    }

    @Override
    public NodeConfiguration addDeploymentComposite(String contributionURI, InputStream content) {
        this.findContribution(contributionURI).addDeploymentComposite(content);
        return this;
    }

    @Override
    public NodeConfiguration addDeploymentComposite(String contributionURI, Reader content) {
        this.findContribution(contributionURI).addDeploymentComposite(content);
        return this;
    }

    @Override
    public NodeConfiguration addDeploymentComposite(String contributionURI, String location) {
        this.findContribution(contributionURI).addDeploymentComposite(URI.create(location));
        return this;
    }

    private ContributionConfiguration findContribution(String uri) {
        for (ContributionConfiguration c : this.contributions) {
            if (c.getURI() == null || !c.getURI().equals(uri)) continue;
            return c;
        }
        throw new IllegalArgumentException("Contribution is not found (uri=" + uri + ")");
    }

    public String toString() {
        if (this.domainURI != null) {
            return "{" + this.domainURI + "}" + this.uri;
        }
        return this.uri;
    }

    @Override
    public List<Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getDomainRegistryURI() {
        return this.domainRegistryURI;
    }

    @Override
    public NodeConfiguration setDomainRegistryURI(String domainRegistryURI) {
        this.domainRegistryURI = domainRegistryURI;
        return this;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public NodeConfiguration setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public List<Endpoint> getEndpointDescriptions() {
        return this.endpoints;
    }
}

