/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.xml;

import java.net.URI;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionRuntimeException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.interfacedef.wsdl.xml.WSDLConstants;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class WSDLInterfaceProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WSDLInterfaceContract>,
WSDLConstants {
    private WSDLFactory wsdlFactory;
    private InterfaceContractMapper interfaceContractMapper;
    private PolicyFactory policyFactory;
    private PolicySubjectProcessor policyProcessor;
    private static String FRAGMENT_INTERFACE = "wsdl.interface";
    private static String FRAGMENT_PORTTYPE = "wsdl.porttype";

    public WSDLInterfaceProcessor(ExtensionPointRegistry registry) {
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.interfaceContractMapper = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(InterfaceContractMapper.class);
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    private WSDLInterface createWSDLInterface(String uri, Monitor monitor) throws ContributionReadException {
        WSDLInterface wsdlInterface = null;
        int index = uri.indexOf(35);
        if (index == -1) {
            this.error(monitor, "InvalidWSDLInterfaceAttr", (Object)this.wsdlFactory, uri);
        } else {
            String namespace = uri.substring(0, index);
            String name = uri.substring(index + 1);
            String porttype = null;
            if (name.contains(FRAGMENT_INTERFACE)) {
                porttype = name.substring("wsdl.interface(".length(), name.length() - 1);
            }
            if (name.contains(FRAGMENT_PORTTYPE)) {
                porttype = name.substring("wsdl.porttype(".length(), name.length() - 1);
            }
            if (porttype == null) {
                this.error(monitor, "InvalidWSDLInterfaceAttr", (Object)this.wsdlFactory, uri);
                return null;
            }
            wsdlInterface = this.wsdlFactory.createWSDLInterface();
            wsdlInterface.setUnresolved(true);
            wsdlInterface.setName(new QName(namespace, porttype));
        }
        return wsdlInterface;
    }

    @Override
    public WSDLInterfaceContract read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String remotable;
        WSDLInterface wsdlCallbackInterface;
        WSDLInterface wsdlInterface;
        WSDLInterfaceContract wsdlInterfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
        Monitor monitor = context.getMonitor();
        String location = reader.getAttributeValue("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation");
        wsdlInterfaceContract.setLocation(location);
        String uri = this.getURIString(reader, "interface");
        if (uri != null && (wsdlInterface = this.createWSDLInterface(uri, monitor)) != null) {
            wsdlInterfaceContract.setInterface(wsdlInterface);
        }
        if ((uri = this.getURIString(reader, "callbackInterface")) != null && (wsdlCallbackInterface = this.createWSDLInterface(uri, monitor)) != null) {
            wsdlInterfaceContract.setCallbackInterface(wsdlCallbackInterface);
        }
        if ((remotable = reader.getAttributeValue(null, "remotable")) != null && !remotable.equals("true")) {
            Monitor.error(monitor, (Object)this, "interface-wsdlxml-validation-messages", "InvalidRemotableValue", ((WSDLInterface)wsdlInterfaceContract.getInterface()).getName().toString(), remotable);
        }
        this.policyProcessor.readPolicies(wsdlInterfaceContract.getInterface(), reader);
        while (reader.hasNext() && (reader.next() != 2 || !INTERFACE_WSDL_QNAME.equals(reader.getName()))) {
        }
        return wsdlInterfaceContract;
    }

    @Override
    public void write(WSDLInterfaceContract wsdlInterfaceContract, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        WSDLInterface wsdlCallbackInterface;
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "interface.wsdl");
        WSDLInterface wsdlInterface = (WSDLInterface)wsdlInterfaceContract.getInterface();
        if (wsdlInterface != null) {
            QName qname = wsdlInterface.getName();
            String uri = qname.getNamespaceURI() + "#wsdl.interface(" + qname.getLocalPart() + ")";
            writer.writeAttribute("interface", uri);
        }
        if ((wsdlCallbackInterface = (WSDLInterface)wsdlInterfaceContract.getCallbackInterface()) != null) {
            QName qname = wsdlCallbackInterface.getName();
            String uri = qname.getNamespaceURI() + "#wsdl.interface(" + qname.getLocalPart() + ")";
            writer.writeAttribute("callbackInterface", uri);
        }
        if (wsdlInterfaceContract.getLocation() != null) {
            writer.writeAttribute("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation", wsdlInterfaceContract.getLocation());
        }
        this.policyProcessor.writePolicyAttributes(wsdlInterface, writer);
        writer.writeEndElement();
    }

    private WSDLInterface resolveWSDLInterface(WSDLInterface wsdlInterface, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (wsdlInterface != null && wsdlInterface.isUnresolved()) {
            Monitor monitor = context.getMonitor();
            if ((wsdlInterface = resolver.resolveModel(WSDLInterface.class, wsdlInterface, context)).isUnresolved()) {
                ContributionResolveException ce;
                WSDLDefinition wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
                wsdlDefinition.setUnresolved(true);
                wsdlDefinition.setNamespace(wsdlInterface.getName().getNamespaceURI());
                wsdlDefinition.setNameOfPortTypeToResolve(wsdlInterface.getName());
                WSDLDefinition resolved = null;
                try {
                    resolved = resolver.resolveModel(WSDLDefinition.class, wsdlDefinition, context);
                }
                catch (ContributionRuntimeException e) {
                    ce = new ContributionResolveException(e.getCause());
                    this.error(monitor, "ContributionResolveException", (Object)wsdlDefinition, ce);
                }
                if (resolved != null && !resolved.isUnresolved()) {
                    wsdlDefinition.setDefinition(resolved.getDefinition());
                    wsdlDefinition.setLocation(resolved.getLocation());
                    wsdlDefinition.setURI(resolved.getURI());
                    wsdlDefinition.getImportedDefinitions().addAll(resolved.getImportedDefinitions());
                    wsdlDefinition.getXmlSchemas().addAll(resolved.getXmlSchemas());
                    wsdlDefinition.setUnresolved(false);
                    WSDLObject<PortType> portType = wsdlDefinition.getWSDLObject(PortType.class, wsdlInterface.getName());
                    if (portType != null) {
                        try {
                            wsdlDefinition.setDefinition(portType.getDefinition());
                            WSDLInterface newWSDLInterface = this.wsdlFactory.createWSDLInterface(portType.getElement(), wsdlDefinition, resolver, monitor);
                            newWSDLInterface.setWsdlDefinition(wsdlDefinition);
                            newWSDLInterface.getRequiredIntents().addAll(wsdlInterface.getRequiredIntents());
                            newWSDLInterface.getPolicySets().addAll(wsdlInterface.getPolicySets());
                            resolver.addModel(newWSDLInterface, context);
                            wsdlInterface = newWSDLInterface;
                        }
                        catch (InvalidInterfaceException e) {
                            String message = context.getMonitor().getMessageString(WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "InvalidInterface");
                            message = message.replace("{0}", portType.toString());
                            ContributionResolveException ce2 = new ContributionResolveException(message, e);
                            this.error(monitor, "ContributionResolveException", (Object)this.wsdlFactory, ce2);
                        }
                    } else {
                        this.warning(monitor, "WsdlInterfaceDoesNotMatch", wsdlDefinition, wsdlInterface.getName());
                    }
                } else {
                    String message = context.getMonitor().getMessageString(WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "WSDLDefinitionUnresolved");
                    message = message.replace("{0}", wsdlInterface.getName().toString());
                    ce = new ContributionResolveException(message);
                    this.error(monitor, "ContributionResolveException", (Object)this.wsdlFactory, ce);
                }
            }
        }
        return wsdlInterface;
    }

    public static WSDLInterface resolveWSDLInterface(WSDLInterface wsdlInterface, ModelResolver resolver, Monitor monitor, WSDLFactory wsdlFactory) {
        ProcessorContext context;
        if (wsdlInterface != null && wsdlInterface.isUnresolved() && (wsdlInterface = resolver.resolveModel(WSDLInterface.class, wsdlInterface, context = new ProcessorContext(monitor))).isUnresolved()) {
            WSDLDefinition wsdlDefinition = wsdlFactory.createWSDLDefinition();
            wsdlDefinition.setUnresolved(true);
            wsdlDefinition.setNamespace(wsdlInterface.getName().getNamespaceURI());
            WSDLDefinition resolved = resolver.resolveModel(WSDLDefinition.class, wsdlDefinition, context);
            if (!resolved.isUnresolved()) {
                wsdlDefinition.setDefinition(resolved.getDefinition());
                wsdlDefinition.setLocation(resolved.getLocation());
                wsdlDefinition.setURI(resolved.getURI());
                wsdlDefinition.getImportedDefinitions().addAll(resolved.getImportedDefinitions());
                wsdlDefinition.getXmlSchemas().addAll(resolved.getXmlSchemas());
                wsdlDefinition.setUnresolved(false);
                WSDLObject<PortType> portType = wsdlDefinition.getWSDLObject(PortType.class, wsdlInterface.getName());
                if (portType != null) {
                    try {
                        wsdlDefinition.setDefinition(portType.getDefinition());
                        wsdlInterface = wsdlFactory.createWSDLInterface(portType.getElement(), wsdlDefinition, resolver, monitor);
                        wsdlInterface.setWsdlDefinition(wsdlDefinition);
                        resolver.addModel(wsdlInterface, context);
                    }
                    catch (InvalidInterfaceException e) {
                        String message = context.getMonitor().getMessageString(WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "InvalidInterface");
                        message = message.replace("{0}", portType.toString());
                        ContributionResolveException ce = new ContributionResolveException(message, e);
                        Monitor.error(monitor, (Object)WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "ContributionResolveException", wsdlFactory.getClass().getName(), ce.getMessage());
                    }
                } else {
                    Monitor.warning(monitor, (Object)WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "WsdlInterfaceDoesNotMatch", wsdlDefinition.getNamespace(), wsdlInterface.getName().toString());
                }
            } else {
                String message = context.getMonitor().getMessageString(WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "WSDLDefinitionUnresolved");
                message = message.replace("{0}", wsdlInterface.getName().toString());
                ContributionResolveException ce = new ContributionResolveException(message);
                Monitor.error(monitor, (Object)WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "ContributionResolveException", wsdlFactory.getClass().getName(), ce.getMessage());
            }
        }
        return wsdlInterface;
    }

    @Override
    public void resolve(WSDLInterfaceContract wsdlInterfaceContract, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        Monitor monitor = context.getMonitor();
        WSDLInterface wsdlInterface = (WSDLInterface)wsdlInterfaceContract.getInterface();
        if (wsdlInterfaceContract.getLocation() != null && wsdlInterface.getWsdlDefinition() == null) {
            WSDLDefinition wsdlDefinition = null;
            URI wsdlFileURI = null;
            try {
                wsdlFileURI = new URI(wsdlInterfaceContract.getLocation());
            }
            catch (Exception ex) {
                Monitor.error(context.getMonitor(), (Object)WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "wsdliLocationException", ex.getMessage());
                return;
            }
            try {
                if (wsdlFileURI.isAbsolute()) {
                    wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
                    wsdlDefinition.setUnresolved(true);
                    wsdlDefinition.setNamespace("nonamespace");
                    wsdlDefinition.getWsdliLocations().put("nonamespace", wsdlInterfaceContract.getLocation());
                    wsdlDefinition.setLocation(new URI(wsdlInterfaceContract.getLocation()));
                } else {
                    for (Artifact artifact : context.getContribution().getArtifacts()) {
                        if (!artifact.getLocation().endsWith(wsdlInterfaceContract.getLocation())) continue;
                        WSDLDefinition artifactWSDLDefinition = (WSDLDefinition)artifact.getModel();
                        wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
                        wsdlDefinition.setUnresolved(true);
                        wsdlDefinition.setNamespace(artifactWSDLDefinition.getNamespace());
                        wsdlDefinition.getWsdliLocations().put(artifactWSDLDefinition.getNamespace(), artifact.getLocation());
                        wsdlDefinition.setLocation(new URI(artifact.getLocation()));
                        break;
                    }
                    if (wsdlDefinition == null) {
                        Monitor.error(context.getMonitor(), (Object)WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "wsdliLocationException", "WSDL not found inside contribution at relative URI " + wsdlFileURI);
                        return;
                    }
                }
            }
            catch (Exception ex) {
                Monitor.error(context.getMonitor(), (Object)WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "wsdliLocationException", ex.getMessage());
                return;
            }
            wsdlDefinition.setUnresolved(true);
            wsdlDefinition = resolver.resolveModel(WSDLDefinition.class, wsdlDefinition, context);
            PortType portType = (PortType)wsdlDefinition.getDefinition().getAllPortTypes().values().iterator().next();
            try {
                WSDLInterface newWSDLInterface = this.wsdlFactory.createWSDLInterface(portType, wsdlDefinition, resolver, monitor);
                newWSDLInterface.getRequiredIntents().addAll(wsdlInterface.getRequiredIntents());
                newWSDLInterface.getPolicySets().addAll(wsdlInterface.getPolicySets());
                wsdlInterface = newWSDLInterface;
            }
            catch (InvalidInterfaceException e) {
                String message = context.getMonitor().getMessageString(WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "InvalidInterface");
                message = message.replace("{0}", portType.toString());
                ContributionResolveException ce = new ContributionResolveException(message, e);
                this.error(monitor, "ContributionResolveException", (Object)this.wsdlFactory, ce);
            }
            wsdlInterface.setWsdlDefinition(wsdlDefinition);
            wsdlInterfaceContract.setInterface(wsdlInterface);
        }
        wsdlInterface = this.resolveWSDLInterface(wsdlInterface, resolver, context);
        wsdlInterfaceContract.setInterface(wsdlInterface);
        WSDLInterface intrinsicWSDLCallbackInterface = wsdlInterface.getCallbackInterface();
        WSDLInterface wsdlCallbackInterface = this.resolveWSDLInterface((WSDLInterface)wsdlInterfaceContract.getCallbackInterface(), resolver, context);
        if (intrinsicWSDLCallbackInterface != null) {
            if (wsdlCallbackInterface != null && !this.interfaceContractMapper.isMutuallyCompatible(intrinsicWSDLCallbackInterface, wsdlCallbackInterface)) {
                Monitor.error(context.getMonitor(), (Object)WSDLInterfaceProcessor.class.getName(), "interface-wsdlxml-validation-messages", "IncompatibleCallbacks", intrinsicWSDLCallbackInterface.getName().toString(), wsdlCallbackInterface.getName().toString());
            }
            wsdlInterfaceContract.setCallbackInterface(intrinsicWSDLCallbackInterface);
        } else {
            wsdlInterfaceContract.setCallbackInterface(wsdlCallbackInterface);
        }
    }

    @Override
    public QName getArtifactType() {
        return WSDLConstants.INTERFACE_WSDL_QNAME;
    }

    @Override
    public Class<WSDLInterfaceContract> getModelType() {
        return WSDLInterfaceContract.class;
    }
}

