/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public class WrapperInfo
implements Cloneable {
    private String dataBinding;
    private ElementInfo wrapperElement;
    private List<ElementInfo> childElements;
    private DataType<XMLType> wrapperType;
    private DataType<List<DataType>> unwrappedType;

    public WrapperInfo(String dataBinding, ElementInfo wrapperElement, List<ElementInfo> childElements) {
        this.dataBinding = dataBinding;
        this.wrapperElement = wrapperElement;
        this.childElements = childElements;
    }

    public List<ElementInfo> getChildElements() {
        return this.childElements;
    }

    public ElementInfo getWrapperElement() {
        return this.wrapperElement;
    }

    public String getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(String dataBinding) {
        this.dataBinding = dataBinding;
    }

    public DataType<XMLType> getWrapperType() {
        return this.wrapperType;
    }

    public void setWrapperType(DataType<XMLType> wrapperType) {
        this.wrapperType = wrapperType;
    }

    public Class<?> getWrapperClass() {
        return this.wrapperType == null ? null : this.wrapperType.getPhysical();
    }

    public Object clone() throws CloneNotSupportedException {
        WrapperInfo copy = (WrapperInfo)super.clone();
        if (this.wrapperType != null) {
            copy.wrapperType = (DataType)this.wrapperType.clone();
        }
        return copy;
    }

    public DataType<List<DataType>> getUnwrappedType() {
        if (this.unwrappedType == null) {
            ArrayList<DataType> childTypes = new ArrayList<DataType>();
            for (ElementInfo element : this.getChildElements()) {
                DataType type = this.getDataType(element);
                childTypes.add(type);
            }
            this.unwrappedType = new DataTypeImpl("idl:unwrapped", Object[].class, childTypes);
        }
        return this.unwrappedType;
    }

    private DataType getDataType(ElementInfo element) {
        DataTypeImpl<Object> type = null;
        if (element.isMany()) {
            DataTypeImpl<XMLType> logical = new DataTypeImpl<XMLType>(this.dataBinding, Object.class, new XMLType(element));
            type = new DataTypeImpl<DataTypeImpl<XMLType>>("java:array", Object[].class, logical);
        } else {
            type = new DataTypeImpl<XMLType>(this.dataBinding, Object.class, new XMLType(element));
        }
        return type;
    }
}

