/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;

public class JAXWSUtils {
    public static JavaInterface configureJavaInterface(JavaInterface javaInterface, Class<?> clazz) {
        WebServiceProvider webServiceProviderAnnotation;
        String servineNamespace = JavaXMLMapper.getNamespace(clazz);
        String serviceName = clazz.getSimpleName();
        QName serviceQName = null;
        String serviceInterfaceClassName = null;
        String wsdlFileName = null;
        WebService webServiceAnnotation = clazz.getAnnotation(WebService.class);
        if (webServiceAnnotation != null) {
            servineNamespace = JAXWSUtils.getValue(webServiceAnnotation.targetNamespace(), servineNamespace);
            serviceName = JAXWSUtils.getValue(webServiceAnnotation.name(), serviceName);
            serviceInterfaceClassName = webServiceAnnotation.endpointInterface();
            wsdlFileName = webServiceAnnotation.wsdlLocation();
            javaInterface.setRemotable(true);
        }
        if ((webServiceProviderAnnotation = clazz.getAnnotation(WebServiceProvider.class)) != null) {
            servineNamespace = JAXWSUtils.getValue(webServiceProviderAnnotation.targetNamespace(), servineNamespace);
            serviceName = JAXWSUtils.getValue(webServiceProviderAnnotation.serviceName(), serviceName);
            wsdlFileName = webServiceProviderAnnotation.wsdlLocation();
            javaInterface.setRemotable(true);
        }
        serviceQName = new QName(servineNamespace, serviceName);
        javaInterface.setQName(serviceQName);
        if (serviceInterfaceClassName != null && serviceInterfaceClassName.length() > 0) {
            javaInterface.setName(serviceInterfaceClassName);
            javaInterface.setJAXWSJavaInterfaceName(serviceInterfaceClassName);
            javaInterface.setUnresolved(true);
        }
        if (wsdlFileName != null && wsdlFileName.length() > 0) {
            javaInterface.setJAXWSWSDLLocation(wsdlFileName);
        }
        return javaInterface;
    }

    private static String getValue(String value, String defaultValue) {
        return "".equals(value) ? defaultValue : value;
    }
}

