/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.introspect;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.common.java.reflection.JavaIntrospectionHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.implementation.java.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.spring.SpringBeanElement;
import org.apache.tuscany.sca.implementation.spring.SpringConstructorArgElement;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.SpringPropertyElement;
import org.apache.tuscany.sca.implementation.spring.SpringSCAPropertyElement;
import org.apache.tuscany.sca.implementation.spring.SpringSCAReferenceElement;
import org.apache.tuscany.sca.implementation.spring.SpringSCAServiceElement;
import org.apache.tuscany.sca.implementation.spring.introspect.SpringBeanIntrospector;
import org.apache.tuscany.sca.implementation.spring.xml.SpringXMLBeanDefinitionLoader;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Remotable;

public class SpringXMLComponentTypeLoader {
    private static final Logger log = Logger.getLogger(SpringXMLComponentTypeLoader.class.getName());
    private ExtensionPointRegistry registry;
    private ContributionFactory contributionFactory;
    private AssemblyFactory assemblyFactory;
    private PolicyFactory policyFactory;
    private JavaInterfaceFactory javaFactory;
    private SpringBeanIntrospector beanIntrospector;
    private SpringXMLBeanDefinitionLoader xmlBeanDefinitionLoader;
    private JavaIntrospectionHelper javaIntrospectionHelper;

    public SpringXMLComponentTypeLoader(ExtensionPointRegistry registry) {
        this.registry = registry;
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = factories.getFactory(AssemblyFactory.class);
        this.policyFactory = factories.getFactory(PolicyFactory.class);
        this.javaFactory = factories.getFactory(JavaInterfaceFactory.class);
        this.contributionFactory = factories.getFactory(ContributionFactory.class);
        this.xmlBeanDefinitionLoader = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(SpringXMLBeanDefinitionLoader.class);
        this.javaIntrospectionHelper = JavaIntrospectionHelper.getInstance(registry);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-spring-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-spring-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    protected Class<SpringImplementation> getImplementationClass() {
        return SpringImplementation.class;
    }

    public void load(SpringImplementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionReadException {
        ComponentType componentType = implementation.getComponentType();
        if (componentType == null) {
            throw new ContributionReadException("SpringXMLLoader load: implementation has no ComponentType object");
        }
        if (componentType.isUnresolved()) {
            this.loadFromXML(implementation, resolver, context);
            if (!componentType.isUnresolved()) {
                implementation.setUnresolved(false);
            }
        }
    }

    private Class<?> resolveClass(ModelResolver resolver, String className, ProcessorContext context) throws ClassNotFoundException {
        ClassReference classReference = new ClassReference(className);
        if ((classReference = resolver.resolveModel(ClassReference.class, classReference, context)).isUnresolved()) {
            throw new ClassNotFoundException(className);
        }
        Class<?> javaClass = classReference.getJavaClass();
        return javaClass;
    }

    private void loadFromXML(SpringImplementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionReadException {
        ArrayList<SpringBeanElement> beans = new ArrayList<SpringBeanElement>();
        ArrayList<SpringSCAServiceElement> services = new ArrayList<SpringSCAServiceElement>();
        ArrayList<SpringSCAReferenceElement> references = new ArrayList<SpringSCAReferenceElement>();
        ArrayList<SpringSCAPropertyElement> scaproperties = new ArrayList<SpringSCAPropertyElement>();
        ArrayList<URL> contextResources = new ArrayList();
        String contextPath = implementation.getLocation();
        try {
            URL resource = this.resolveLocation(resolver, contextPath, context);
            contextResources = this.getApplicationContextResource(resource);
            implementation.setClassLoader(new ContextClassLoader(resolver, context));
            implementation.setResource(contextResources);
            implementation.setURI(resource.toString());
            ArrayList<SpringBeanElement> appCxtBeans = new ArrayList<SpringBeanElement>();
            ArrayList<SpringSCAServiceElement> appCxtServices = new ArrayList<SpringSCAServiceElement>();
            ArrayList<SpringSCAReferenceElement> appCxtReferences = new ArrayList<SpringSCAReferenceElement>();
            ArrayList<SpringSCAPropertyElement> appCxtProperties = new ArrayList<SpringSCAPropertyElement>();
            if (this.xmlBeanDefinitionLoader != null) {
                this.xmlBeanDefinitionLoader.load(contextResources, appCxtServices, appCxtReferences, appCxtProperties, appCxtBeans, context);
                this.populatePolicies(appCxtServices, appCxtReferences);
            }
            this.validateBeans(appCxtBeans, appCxtServices, appCxtReferences, appCxtProperties, context.getMonitor());
            beans.addAll(appCxtBeans);
            services.addAll(appCxtServices);
            references.addAll(appCxtReferences);
            scaproperties.addAll(appCxtProperties);
        }
        catch (Throwable e) {
            throw new ContributionReadException(e);
        }
        this.generateComponentType(implementation, resolver, beans, services, references, scaproperties, context);
    }

    public void populatePolicies(List<SpringSCAServiceElement> appCxtServices, List<SpringSCAReferenceElement> appCxtReferences) {
        PolicySet ps;
        Intent intent;
        for (SpringSCAReferenceElement springSCAReferenceElement : appCxtReferences) {
            for (QName qn : springSCAReferenceElement.getIntentNames()) {
                intent = this.policyFactory.createIntent();
                intent.setName(qn);
                springSCAReferenceElement.getRequiredIntents().add(intent);
            }
            for (QName qn : springSCAReferenceElement.getPolicySetNames()) {
                ps = this.policyFactory.createPolicySet();
                ps.setName(qn);
                springSCAReferenceElement.getPolicySets().add(ps);
            }
        }
        for (SpringSCAServiceElement springSCAServiceElement : appCxtServices) {
            for (QName qn : springSCAServiceElement.getIntentNames()) {
                intent = this.policyFactory.createIntent();
                intent.setName(qn);
                springSCAServiceElement.getRequiredIntents().add(intent);
            }
            for (QName qn : springSCAServiceElement.getPolicySetNames()) {
                ps = this.policyFactory.createPolicySet();
                ps.setName(qn);
                springSCAServiceElement.getPolicySets().add(ps);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL resolveLocation(ModelResolver resolver, String contextPath, ProcessorContext context) throws MalformedURLException, ContributionReadException {
        URI base;
        URL resource = null;
        URI uri = URI.create(contextPath);
        if (uri.isAbsolute()) return new URL(contextPath);
        Artifact parent = context.getArtifact();
        if (parent != null && parent.getURI() != null && (uri = (base = URI.create("/" + parent.getURI())).resolve(uri)).toString().startsWith("/")) {
            uri = URI.create(uri.toString().substring(1));
        }
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setUnresolved(true);
        artifact.setURI(uri.toString());
        artifact = resolver.resolveModel(Artifact.class, artifact, context);
        if (!artifact.isUnresolved()) {
            return new URL(artifact.getLocation());
        }
        if (parent == null) throw new ContributionReadException("Location cannot be resloved: " + contextPath);
        if (parent.getLocation() == null) throw new ContributionReadException("Location cannot be resloved: " + contextPath);
        return new URL(new URL(parent.getLocation()), contextPath);
    }

    private void generateComponentType(SpringImplementation implementation, ModelResolver resolver, List<SpringBeanElement> beans, List<SpringSCAServiceElement> services, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties, ProcessorContext context) throws ContributionReadException {
        ComponentType componentType;
        block30: {
            JavaImplementation javaImplementation = null;
            componentType = implementation.getComponentType();
            try {
                for (SpringSCAServiceElement serviceElement : services) {
                    Class<?> interfaze = serviceElement.getType() != null ? this.resolveClass(resolver, serviceElement.getType(), context) : this.getBeanInterface(resolver, serviceElement.getTarget(), beans, context);
                    Service theService = this.createService(interfaze, serviceElement.getName());
                    Service duplicate = null;
                    for (Service service : componentType.getServices()) {
                        if (!service.getName().equals(theService.getName())) continue;
                        duplicate = service;
                    }
                    if (duplicate != null) {
                        componentType.getServices().remove(duplicate);
                    }
                    componentType.getServices().add(theService);
                    String beanName = serviceElement.getTarget();
                    boolean found = false;
                    for (SpringBeanElement beanElement : beans) {
                        if (!beanName.equals(beanElement.getId()) || !this.isValidBeanForService(beanElement)) continue;
                        theService.getRequiredIntents().addAll(serviceElement.getRequiredIntents());
                        theService.getPolicySets().addAll(serviceElement.getPolicySets());
                        implementation.setBeanForService(theService, beanElement);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    implementation.setBeanForService(theService, new SpringBeanElement(serviceElement.getTarget(), null));
                }
                for (SpringSCAReferenceElement referenceElement : references) {
                    Class<?> interfaze = this.resolveClass(resolver, referenceElement.getType(), context);
                    Reference theReference = this.createReference(interfaze, referenceElement.getName());
                    Reference duplicate = null;
                    for (Reference reference : componentType.getReferences()) {
                        if (!reference.getName().equals(theReference.getName())) continue;
                        duplicate = reference;
                    }
                    if (duplicate != null) {
                        componentType.getReferences().remove(duplicate);
                    }
                    theReference.getRequiredIntents().addAll(referenceElement.getRequiredIntents());
                    theReference.getPolicySets().addAll(referenceElement.getPolicySets());
                    componentType.getReferences().add(theReference);
                }
                for (SpringSCAPropertyElement scaproperty : scaproperties) {
                    if (scaproperty.getType() == null || scaproperty.getName() == null) continue;
                    org.apache.tuscany.sca.assembly.Property theProperty = this.assemblyFactory.createProperty();
                    theProperty.setName(scaproperty.getName());
                    Class<?> propType = Class.forName(scaproperty.getType());
                    theProperty.setXSDType(JavaXMLMapper.getXMLType(propType));
                    org.apache.tuscany.sca.assembly.Property duplicate = null;
                    for (org.apache.tuscany.sca.assembly.Property property : componentType.getProperties()) {
                        if (!property.getName().equals(theProperty.getName())) continue;
                        duplicate = property;
                    }
                    if (duplicate != null) {
                        componentType.getProperties().remove(duplicate);
                    }
                    componentType.getProperties().add(theProperty);
                    implementation.setPropertyClass(theProperty.getName(), propType);
                }
                if (services.isEmpty()) {
                    for (SpringBeanElement beanElement : beans) {
                        if (!this.isValidBeanForService(beanElement)) continue;
                        try {
                            Class<?> beanClass = this.resolveClass(resolver, beanElement.getClassName(), context);
                            this.beanIntrospector = new SpringBeanIntrospector(this.registry, beanElement.getCustructorArgs());
                            ComponentType beanComponentType = this.assemblyFactory.createComponentType();
                            javaImplementation = this.beanIntrospector.introspectBean(beanClass, beanComponentType);
                            for (Service componentService : beanComponentType.getServices()) {
                                componentService.setName(beanElement.getId());
                            }
                            List<Service> beanServices = beanComponentType.getServices();
                            componentType.getServices().addAll(beanServices);
                            for (Service beanService : beanServices) {
                                implementation.setBeanForService(beanService, beanElement);
                            }
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
                if (!references.isEmpty() || !scaproperties.isEmpty()) break block30;
                for (SpringBeanElement beanElement : beans) {
                    if (!this.isValidBeanForService(beanElement) || beanElement.getProperties().isEmpty() && beanElement.getCustructorArgs().isEmpty()) continue;
                    ComponentType beanComponentType = this.assemblyFactory.createComponentType();
                    try {
                        Class<?> beanClass = this.resolveClass(resolver, beanElement.getClassName(), context);
                        this.beanIntrospector = new SpringBeanIntrospector(this.registry, beanElement.getCustructorArgs());
                        javaImplementation = this.beanIntrospector.introspectBean(beanClass, beanComponentType);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        continue;
                    }
                    Map<String, JavaElementImpl> propertyMap = javaImplementation.getPropertyMembers();
                    JavaConstructorImpl<?> constructor = javaImplementation.getConstructor();
                    List<Reference> beanReferences = beanComponentType.getReferences();
                    List<org.apache.tuscany.sca.assembly.Property> beanProperties = beanComponentType.getProperties();
                    HashSet<String> excludedNames = new HashSet<String>();
                    for (SpringPropertyElement propertyElement : beanElement.getProperties()) {
                        excludedNames.add(propertyElement.getName());
                        block19: for (String propertyRef : propertyElement.getRefs()) {
                            if (!this.propertyRefUnresolved(propertyRef, beans, references, scaproperties)) continue;
                            for (Reference reference : beanReferences) {
                                if (!propertyElement.getName().equals(reference.getName())) continue;
                                reference.setName(propertyRef);
                                componentType.getReferences().add(reference);
                                break;
                            }
                            for (org.apache.tuscany.sca.assembly.Property scaproperty : beanProperties) {
                                if (!propertyElement.getName().equals(scaproperty.getName())) continue;
                                Class<?> interfaze = this.resolveClass(resolver, propertyMap.get(propertyElement.getName()).getType().getName(), context);
                                Reference theReference = this.createReference(interfaze, propertyRef);
                                implementation.setUnresolvedBeanRef(propertyRef, theReference);
                                continue block19;
                            }
                        }
                    }
                    for (SpringConstructorArgElement conArgElement : beanElement.getCustructorArgs()) {
                        for (String constructorArgRef : conArgElement.getRefs()) {
                            if (!this.propertyRefUnresolved(constructorArgRef, beans, references, scaproperties)) continue;
                            for (JavaParameterImpl parameter : constructor.getParameters()) {
                                String paramType = parameter.getType().getName();
                                Class<?> interfaze = this.resolveClass(resolver, paramType, context);
                                if ((conArgElement.getType() == null || !paramType.equals(conArgElement.getType())) && (conArgElement.getIndex() == -1 || conArgElement.getIndex() != parameter.getIndex()) || parameter.getClassifer() != Property.class) continue;
                                Reference theReference = this.createReference(interfaze, constructorArgRef);
                                implementation.setUnresolvedBeanRef(constructorArgRef, theReference);
                            }
                        }
                    }
                    for (Reference ref : beanReferences) {
                        if (excludedNames.contains(ref.getName()) || componentType.getReference(ref.getName()) != null) continue;
                        componentType.getReferences().add(ref);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new ContributionReadException(e);
            }
            catch (InvalidInterfaceException e) {
                throw new ContributionReadException(e);
            }
        }
        componentType.setUnresolved(false);
        implementation.setComponentType(componentType);
    }

    private Class<?> getBeanInterface(ModelResolver resolver, String target, List<SpringBeanElement> beans, ProcessorContext context) throws ClassNotFoundException {
        SpringBeanElement bean = null;
        for (SpringBeanElement sbe : beans) {
            if (!sbe.getId().equals(target)) continue;
            bean = sbe;
            break;
        }
        if (bean == null) {
            this.error(context.getMonitor(), "TargetBeanDoesNotExist", null, target);
            return null;
        }
        Class<?> beanClass = this.resolveClass(resolver, bean.getClassName(), context);
        List<Class<?>> ifaces = this.javaIntrospectionHelper.getAllInterfaces(beanClass);
        for (Class<?> interfaze : ifaces) {
            if (!interfaze.isAnnotationPresent(Remotable.class)) continue;
            return interfaze;
        }
        return beanClass;
    }

    private boolean propertyRefUnresolved(String ref, List<SpringBeanElement> beans, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties) {
        boolean unresolved = true;
        if (ref != null) {
            for (SpringBeanElement beanElement : beans) {
                if (!ref.equals(beanElement.getId())) continue;
                unresolved = false;
                break;
            }
            if (unresolved) {
                for (SpringSCAReferenceElement referenceElement : references) {
                    if (!ref.equals(referenceElement.getName())) continue;
                    unresolved = false;
                    break;
                }
            }
            if (unresolved) {
                for (SpringSCAPropertyElement propertyElement : scaproperties) {
                    if (!ref.equals(propertyElement.getName())) continue;
                    unresolved = false;
                    break;
                }
            }
        } else {
            unresolved = false;
        }
        return unresolved;
    }

    private void validateBeans(List<SpringBeanElement> beans, List<SpringSCAServiceElement> services, List<SpringSCAReferenceElement> references, List<SpringSCAPropertyElement> scaproperties, Monitor monitor) throws ContributionReadException {
        for (SpringSCAServiceElement serviceElement : services) {
            for (SpringSCAServiceElement x : services) {
                if (serviceElement == x || !serviceElement.getName().equals(x.getName())) continue;
                this.error(monitor, "ScaServiceNameNotUnique", beans, new Object[0]);
            }
        }
        for (SpringSCAServiceElement serviceElement : services) {
            boolean targetBeanExists = false;
            for (SpringBeanElement beanElement : beans) {
                if (!serviceElement.getTarget().equals(beanElement.getId())) continue;
                targetBeanExists = true;
            }
            if (targetBeanExists) continue;
            this.warning(monitor, "TargetBeanDoesNotExist", beans, new Object[0]);
        }
        for (SpringSCAReferenceElement referenceElement : references) {
            boolean defaultBeanExists = false;
            boolean isUniqueReferenceName = true;
            for (SpringBeanElement beanElement : beans) {
                if (referenceElement.getDefaultBean() != null && referenceElement.getDefaultBean().equals(beanElement.getId())) {
                    defaultBeanExists = true;
                }
                if (!referenceElement.getName().equals(beanElement.getId())) continue;
                isUniqueReferenceName = false;
            }
            for (SpringSCAPropertyElement propertyElement : scaproperties) {
                if (!referenceElement.getName().equals(propertyElement.getName())) continue;
                isUniqueReferenceName = false;
            }
            if (!defaultBeanExists && referenceElement.getDefaultBean() != null) {
                this.error(monitor, "DefaultBeanDoesNotExist", beans, new Object[0]);
            }
            if (isUniqueReferenceName) continue;
            this.error(monitor, "ScaReferenceNameNotUnique", beans, new Object[0]);
        }
        for (SpringSCAPropertyElement propertyElement : scaproperties) {
            boolean isUniquePropertyName = true;
            for (SpringBeanElement beanElement : beans) {
                if (!propertyElement.getName().equals(beanElement.getId())) continue;
                isUniquePropertyName = false;
            }
            for (SpringSCAReferenceElement referenceElement : references) {
                if (!propertyElement.getName().equals(referenceElement.getName())) continue;
                isUniquePropertyName = false;
            }
            if (isUniquePropertyName) continue;
            this.error(monitor, "ScaPropertyNameNotUnique", beans, new Object[0]);
        }
    }

    private boolean isValidBeanForService(SpringBeanElement beanElement) {
        if (beanElement.isInnerBean()) {
            return false;
        }
        if (beanElement.hasParentAttribute()) {
            return false;
        }
        if (beanElement.hasFactoryMethodAttribute()) {
            return false;
        }
        if (beanElement.hasFactoryBeanAttribute()) {
            return false;
        }
        if (beanElement.getClassName() == null) {
            return false;
        }
        return !beanElement.getClassName().startsWith("org.springframework");
    }

    protected List<URL> getApplicationContextResource(URL url) throws ContributionReadException {
        block21: {
            File manifestFile = null;
            File locationFile = null;
            ArrayList<URL> appCtxResources = new ArrayList<URL>();
            if (url == null) {
                throw new ContributionReadException("SpringXMLComponentTypeLoader getApplicationContextResource: unable to find resource file " + url);
            }
            String path = url.getPath();
            locationFile = new File(path);
            if (locationFile.isDirectory()) {
                try {
                    Manifest mf;
                    Attributes mainAttrs;
                    String appCtxPath;
                    manifestFile = new File(locationFile, "META-INF" + File.separator + "MANIFEST.MF");
                    if (manifestFile.exists() && (appCtxPath = (mainAttrs = (mf = new Manifest(new FileInputStream(manifestFile))).getMainAttributes()).getValue("Spring-Context")) != null) {
                        String[] cxtPaths;
                        for (String path2 : cxtPaths = appCtxPath.split(";")) {
                            File appXmlFile = new File(locationFile, path2.trim());
                            if (!appXmlFile.exists()) continue;
                            appCtxResources.add(appXmlFile.toURI().toURL());
                        }
                        return appCtxResources;
                    }
                    File appXmlFolder = new File(locationFile, "META-INF" + File.separator + "spring");
                    if (appXmlFolder.exists()) {
                        File[] files;
                        for (File appFile : files = appXmlFolder.listFiles()) {
                            if (!appFile.getName().endsWith(".xml")) continue;
                            appCtxResources.add(appFile.toURI().toURL());
                        }
                        return appCtxResources;
                    }
                    break block21;
                }
                catch (IOException e) {
                    throw new ContributionReadException("Error reading manifest " + manifestFile);
                }
            }
            if (locationFile.isFile() && locationFile.getName().endsWith(".jar")) {
                try {
                    Attributes mainAttrs;
                    String appCtxPath;
                    JarFile jf = new JarFile(locationFile);
                    Manifest mf = jf.getManifest();
                    if (mf != null && (appCtxPath = (mainAttrs = mf.getMainAttributes()).getValue("Spring-Context")) != null) {
                        String[] cxtPaths;
                        for (String path3 : cxtPaths = appCtxPath.split(";")) {
                            JarEntry je = jf.getJarEntry(path3.trim());
                            if (je == null) continue;
                            appCtxResources.add(new URL("jar:" + locationFile.toURI().toURL() + "!/" + appCtxPath));
                        }
                        return appCtxResources;
                    }
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry je = entries.nextElement();
                        if (!je.getName().startsWith("META-INF/spring/") || !je.getName().endsWith(".xml")) continue;
                        appCtxResources.add(new URL("jar:" + locationFile.toURI().toURL() + "!/" + je.getName()));
                    }
                    return appCtxResources;
                }
                catch (IOException e) {
                    throw new ContributionReadException("SpringXMLComponentTypeLoader getApplicationContextResource:  IO exception reading context file.", e);
                }
            }
            if (locationFile.getName().endsWith(".xml")) {
                appCtxResources.add(url);
                return appCtxResources;
            }
            try {
                if (locationFile.getPath().indexOf(".jar") > 0) {
                    Manifest mf;
                    Attributes mainAttrs;
                    String appCtxPath;
                    String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
                    JarFile jf = new JarFile(jarPath);
                    JarEntry je = jf.getJarEntry(url.getPath().substring(url.getPath().indexOf("!/") + 2) + "/" + "META-INF" + "/" + "MANIFEST.MF");
                    if (je != null && (appCtxPath = (mainAttrs = (mf = new Manifest(jf.getInputStream(je))).getMainAttributes()).getValue("Spring-Context")) != null) {
                        String[] cxtPaths;
                        for (String path4 : cxtPaths = appCtxPath.split(";")) {
                            je = jf.getJarEntry(url.getPath().substring(url.getPath().indexOf("!/") + 2) + "/" + path4.trim());
                            if (je == null) continue;
                            appCtxResources.add(new URL("jar:" + url.getPath() + "/" + path4.trim()));
                        }
                        return appCtxResources;
                    }
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        je = entries.nextElement();
                        if (!je.getName().startsWith("META-INF/spring/") || !je.getName().endsWith(".xml")) continue;
                        appCtxResources.add(new URL("jar:" + url.getPath() + "/" + je.getName()));
                    }
                    return appCtxResources;
                }
            }
            catch (IOException e) {
                throw new ContributionReadException("Error reading manifest " + manifestFile);
            }
        }
        throw new ContributionReadException("SpringXMLComponentTypeLoader getApplicationContextResource: unable to process unknown resource type: " + url);
    }

    public Service createService(Class<?> interfaze, String name) throws InvalidInterfaceException {
        Service service = this.assemblyFactory.createService();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        service.setName(name);
        JavaInterface callInterface = this.javaFactory.createJavaInterface(interfaze);
        service.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
            service.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return service;
    }

    private Reference createReference(Class<?> interfaze, String name) throws InvalidInterfaceException {
        Reference reference = this.assemblyFactory.createReference();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        reference.setName(name);
        reference.setMultiplicity(Multiplicity.ONE_ONE);
        reference.setAllowsPassByReference(true);
        JavaInterface callInterface = this.javaFactory.createJavaInterface(interfaze);
        reference.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
            reference.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return reference;
    }

    private class ContextClassLoader
    extends ClassLoader {
        private ModelResolver resolver;
        private ProcessorContext context;

        public ContextClassLoader(ModelResolver resolver, ProcessorContext context) {
            this.resolver = resolver;
            this.context = context;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return SpringXMLComponentTypeLoader.this.resolveClass(this.resolver, name, this.context);
        }

        @Override
        protected URL findResource(String name) {
            try {
                return SpringXMLComponentTypeLoader.this.resolveLocation(this.resolver, name, this.context);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            URL url = this.findResource(name);
            if (url != null) {
                return Collections.enumeration(Arrays.asList(url));
            }
            List urls = Collections.emptyList();
            return Collections.enumeration(urls);
        }
    }
}

