/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.lang.reflect.Method;
import org.apache.tuscany.sca.context.ComponentContextFactory;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.factory.InstanceWrapper;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopedImplementationProvider;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.ResourceHost;
import org.apache.tuscany.sca.implementation.java.injection.RequestContextObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.ResourceObjectFactory;
import org.apache.tuscany.sca.implementation.java.invocation.JavaAsyncResponseInvokerImpl;
import org.apache.tuscany.sca.implementation.java.invocation.JavaComponentContextFactory;
import org.apache.tuscany.sca.implementation.java.invocation.JavaComponentContextProvider;
import org.apache.tuscany.sca.implementation.java.invocation.JavaComponentNameFactory;
import org.apache.tuscany.sca.implementation.java.invocation.JavaImplementationInvoker;
import org.apache.tuscany.sca.implementation.java.invocation.JavaInstanceFactoryProvider;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncRequest;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.provider.ImplementationAsyncProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.RequestContext;

public class JavaImplementationProvider
implements ScopedImplementationProvider,
ImplementationAsyncProvider {
    private JavaImplementation implementation;
    private JavaComponentContextProvider componentContextProvider;
    private RequestContextFactory requestContextFactory;
    private Scope scope;

    public JavaImplementationProvider(RuntimeComponent component, JavaImplementation implementation, ProxyFactory proxyService, DataBindingExtensionPoint dataBindingRegistry, PropertyValueFactory propertyValueObjectFactory, ComponentContextFactory componentContextFactory, RequestContextFactory requestContextFactory) {
        this.implementation = implementation;
        this.requestContextFactory = requestContextFactory;
        try {
            JavaInstanceFactoryProvider configuration = new JavaInstanceFactoryProvider(implementation);
            configuration.setProxyFactory(proxyService);
            this.componentContextProvider = new JavaComponentContextProvider(component, configuration, dataBindingRegistry, propertyValueObjectFactory, componentContextFactory, requestContextFactory);
            this.scope = new Scope(implementation.getJavaScope().getScope());
            this.componentContextProvider.configureProperties(component.getProperties());
            this.handleResources(implementation, proxyService);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void handleResources(JavaImplementation componentType, ProxyFactory proxyService) {
        for (JavaResourceImpl resource : componentType.getResources().values()) {
            String name = resource.getName();
            ResourceObjectFactory<?> objectFactory = (ResourceObjectFactory<?>)this.componentContextProvider.getInstanceFactoryProvider().getFactories().get(resource.getElement());
            if (objectFactory == null) {
                Class<?> type = resource.getElement().getType();
                if (ComponentContext.class.isAssignableFrom(type)) {
                    objectFactory = new JavaComponentContextFactory(this.componentContextProvider);
                } else if (RequestContext.class.equals(type)) {
                    objectFactory = new RequestContextObjectFactory(this.requestContextFactory, this.componentContextProvider.getComponent());
                } else if (String.class.equals(type)) {
                    objectFactory = new JavaComponentNameFactory(this.componentContextProvider);
                } else {
                    boolean optional = resource.isOptional();
                    String mappedName = resource.getMappedName();
                    ResourceHost resourceHost = resource.getResourceHost();
                    objectFactory = this.createResourceObjectFactory(type, mappedName, optional, resourceHost);
                }
            }
            this.componentContextProvider.addResourceFactory(name, objectFactory);
        }
    }

    private <T> ResourceObjectFactory<T> createResourceObjectFactory(Class<T> type, String mappedName, boolean optional, ResourceHost host) {
        return new ResourceObjectFactory<T>(type, mappedName, optional, host);
    }

    @Override
    public Invoker createInvoker(RuntimeComponentService service, Operation operation) {
        try {
            return this.componentContextProvider.createInvoker(operation, service);
        }
        catch (NoSuchMethodException e) {
            Interface iface = service.getInterfaceContract().getInterface();
            if (iface instanceof JavaInterface) {
                try {
                    Method method = JavaInterfaceUtil.findMethod(((JavaInterface)iface).getJavaClass(), operation);
                    return new JavaImplementationInvoker(operation, method, this.componentContextProvider.getComponent(), service);
                }
                catch (NoSuchMethodException e1) {
                    throw new IllegalArgumentException(e1);
                }
            }
            return new JavaImplementationInvoker(operation, this.componentContextProvider.getComponent(), service);
        }
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public void start() {
        this.componentContextProvider.start();
    }

    @Override
    public void stop() {
        this.componentContextProvider.stop();
    }

    @Override
    public InstanceWrapper<?> createInstanceWrapper() {
        return this.componentContextProvider.createInstanceWrapper();
    }

    @Override
    public boolean isEagerInit() {
        return this.implementation.isEagerInit();
    }

    @Override
    public InvokerAsyncRequest createAsyncInvoker(RuntimeComponentService service, Operation operation) {
        return (InvokerAsyncRequest)((Object)this.createInvoker(service, operation));
    }

    @Override
    public InvokerAsyncResponse createAsyncResponseInvoker(Operation operation) {
        return new JavaAsyncResponseInvokerImpl();
    }
}

