/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.introspect.impl.AbstractPropertyProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.AmbiguousConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidServiceTypeException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.NoConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.Resource;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.Callback;
import org.oasisopen.sca.annotation.ComponentName;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Context;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Remotable;
import org.oasisopen.sca.annotation.Service;

public class HeuristicPojoProcessor
extends BaseJavaClassVisitor {
    public HeuristicPojoProcessor(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory) {
        super(assemblyFactory);
        this.javaInterfaceFactory = javaFactory;
    }

    public HeuristicPojoProcessor(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public <T> void visitEnd(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        List<org.apache.tuscany.sca.assembly.Service> services = type.getServices();
        if (services.isEmpty()) {
            Set<Class<?>> interfaces = JavaIntrospectionHelper.getAllInterfaces(clazz);
            for (Class<?> i : interfaces) {
                if (!i.isAnnotationPresent(Remotable.class) && !i.isAnnotationPresent(WebService.class)) continue;
                this.addService(type, i);
            }
            if (services.isEmpty()) {
                this.addService(type, clazz);
            }
        }
        if (clazz.getAnnotation(Service.class) == null && type.getReferenceMembers().isEmpty() && type.getPropertyMembers().isEmpty()) {
            Set<Method> methods = JavaIntrospectionHelper.getAllUniquePublicProtectedMethods(clazz, false);
            this.calcPropRefs(methods, services, type, clazz);
        }
        this.evaluateConstructor(type, clazz);
    }

    private boolean isImplementationJava(JavaImplementation type) {
        return JavaImplementation.TYPE.equals(type.getType());
    }

    private void addService(JavaImplementation type, Class<?> clazz) throws IntrospectionException {
        try {
            org.apache.tuscany.sca.assembly.Service service = this.createService(clazz);
            type.getServices().add(service);
        }
        catch (InvalidInterfaceException e) {
            throw new IntrospectionException(e);
        }
    }

    private static boolean isAnnotatedWithSCA(AnnotatedElement element) {
        for (Annotation a : element.getAnnotations()) {
            if (HeuristicPojoProcessor.isSCAPolicyAnnotation(a) || !HeuristicPojoProcessor.isSCAAnnotation(a)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotated(AnnotatedElement element) {
        int i$ = 0;
        Annotation[] arr$ = element.getAnnotations();
        int len$ = arr$.length;
        if (i$ < len$) {
            Annotation a = arr$[i$];
            return true;
        }
        return false;
    }

    private static boolean isSCAAnnotation(Annotation a) {
        return a.annotationType().getName().startsWith("org.oasisopen.sca.annotation.");
    }

    private static boolean isSCAPolicyAnnotation(Annotation a) {
        if (a.annotationType().getName().startsWith("org.oasisopen.sca.annotation.PolicySets")) {
            return true;
        }
        return a.annotationType().getName().startsWith("org.oasisopen.sca.annotation.Intent");
    }

    private <T> void calcPropRefs(Set<Method> methods, List<org.apache.tuscany.sca.assembly.Service> services, JavaImplementation type, Class<T> clazz) throws IntrospectionException {
        HashSet<String> setters = new HashSet<String>();
        HashSet<String> others = new HashSet<String>();
        for (Method method : methods) {
            Type genericType;
            if (!HeuristicPojoProcessor.isPublicSetter(method)) continue;
            if (HeuristicPojoProcessor.isAnnotatedWithSCA(method)) {
                others.add(JavaIntrospectionHelper.toPropertyName(method.getName()));
                continue;
            }
            if (HeuristicPojoProcessor.isInServiceInterface(method, services)) continue;
            String name = JavaIntrospectionHelper.toPropertyName(method.getName());
            setters.add(name);
            if (type.getPropertyMembers().containsKey(name) || type.getReferenceMembers().containsKey(name)) continue;
            Class<?> param = method.getParameterTypes()[0];
            if (HeuristicPojoProcessor.isReferenceType(param, genericType = method.getGenericParameterTypes()[0])) {
                type.getReferences().add(this.createReference(name, param, genericType));
                type.getReferenceMembers().put(name, new JavaElementImpl(method, 0));
                continue;
            }
            type.getProperties().add(this.createProperty(name, param, genericType));
            type.getPropertyMembers().put(name, new JavaElementImpl(method, 0));
        }
        for (Method method : methods) {
            if (!HeuristicPojoProcessor.isProtectedSetter(method)) continue;
            if (HeuristicPojoProcessor.isAnnotatedWithSCA(method)) {
                others.add(JavaIntrospectionHelper.toPropertyName(method.getName()));
                continue;
            }
            Class<?> param = method.getParameterTypes()[0];
            Type paramType = method.getGenericParameterTypes()[0];
            String name = JavaIntrospectionHelper.toPropertyName(method.getName());
            setters.add(name);
            if (HeuristicPojoProcessor.isReferenceType(param, method.getGenericParameterTypes()[0])) {
                if (type.getReferenceMembers().containsKey(name)) continue;
                type.getReferences().add(this.createReference(name, param, paramType));
                type.getReferenceMembers().put(name, new JavaElementImpl(method, 0));
                continue;
            }
            if (type.getPropertyMembers().containsKey(name)) continue;
            type.getProperties().add(this.createProperty(name, param, paramType));
            type.getPropertyMembers().put(name, new JavaElementImpl(method, 0));
        }
        Set<Field> fields = JavaIntrospectionHelper.getAllPublicAndProtectedFields(clazz, false);
        for (Field field : fields) {
            if (HeuristicPojoProcessor.isAnnotatedWithSCA(field) || setters.contains(field.getName()) || others.contains(field.getName())) continue;
            String name = field.getName();
            Class<?> paramType = field.getType();
            Type genericType = field.getGenericType();
            if (HeuristicPojoProcessor.isReferenceType(paramType, field.getGenericType())) {
                if (type.getReferenceMembers().containsKey(name)) continue;
                type.getReferences().add(this.createReference(name, paramType, genericType));
                type.getReferenceMembers().put(name, new JavaElementImpl(field));
                continue;
            }
            if (type.getPropertyMembers().containsKey(name) || HeuristicPojoProcessor.isAnnotated(field)) continue;
            type.getProperties().add(this.createProperty(name, paramType, genericType));
            type.getPropertyMembers().put(name, new JavaElementImpl(field));
        }
    }

    private <T> void evaluateConstructor(JavaImplementation type, Class<T> clazz) throws IntrospectionException {
        java.lang.reflect.Constructor<?> constructor;
        JavaConstructorImpl definition = type.getConstructor();
        boolean explict = false;
        if (definition != null && definition.getConstructor().isAnnotationPresent(Constructor.class)) {
            return;
        }
        if (definition != null) {
            explict = true;
            constructor = definition.getConstructor();
        } else {
            if (!this.isImplementationJava(type)) {
                return;
            }
            java.lang.reflect.Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length == 0) {
                throw new NoConstructorException("[JCI50001] No public constructor for class :" + type.getName());
            }
            if (constructors.length == 1) {
                constructor = constructors[0];
            } else {
                java.lang.reflect.Constructor<?> selected = null;
                for (java.lang.reflect.Constructor<?> ctor : constructors) {
                    if (!this.allArgsAnnotated(ctor)) continue;
                    selected = ctor;
                    for (java.lang.reflect.Constructor<?> ctor2 : constructors) {
                        if (selected == ctor2 || !this.allArgsAnnotated(ctor2)) continue;
                        throw new InvalidConstructorException("[JCI50005] Multiple annotated constructors for class :" + type.getName());
                    }
                }
                if (selected == null) {
                    for (java.lang.reflect.Constructor<?> ctor : constructors) {
                        if (ctor.getParameterTypes().length != 0) continue;
                        selected = ctor;
                        break;
                    }
                }
                if (selected == null) {
                    throw new NoConstructorException();
                }
                constructor = selected;
                definition = type.getConstructors().get(selected);
                type.setConstructor(definition);
            }
            definition = type.getConstructors().get(constructor);
            type.setConstructor(definition);
        }
        JavaParameterImpl[] parameters = definition.getParameters();
        if (parameters.length == 0) {
            return;
        }
        Map<String, JavaElementImpl> props = type.getPropertyMembers();
        Map<String, JavaElementImpl> refs = type.getReferenceMembers();
        Annotation[][] annotations = constructor.getParameterAnnotations();
        if (!explict) {
            explict = HeuristicPojoProcessor.injectionAnnotationsPresent(annotations);
        }
        if (explict) {
            for (int i = 0; i < parameters.length; ++i) {
                if (HeuristicPojoProcessor.isAnnotated(parameters[i]) || this.findReferenceOrProperty(parameters[i], props, refs)) continue;
                throw new AmbiguousConstructorException(parameters[i].toString());
            }
        } else {
            if (!HeuristicPojoProcessor.areUnique(parameters)) {
                throw new AmbiguousConstructorException("Cannot resolve non-unique parameter types, use @Constructor");
            }
            if (!this.calcPropRefUniqueness(props.values(), refs.values())) {
                throw new AmbiguousConstructorException("Cannot resolve non-unique parameter types, use @Constructor");
            }
            if (!props.isEmpty() || !refs.isEmpty()) {
                this.calcParamNames(parameters, props, refs);
            } else {
                this.heuristicParamNames(type, parameters);
            }
        }
    }

    private boolean allArgsAnnotated(java.lang.reflect.Constructor<?> ctor) {
        if (ctor.getParameterTypes().length < 1) {
            return false;
        }
        for (Annotation[] as : ctor.getParameterAnnotations()) {
            if (as.length >= 1) continue;
            return false;
        }
        return true;
    }

    private void calcParamNames(JavaParameterImpl[] parameters, Map<String, JavaElementImpl> props, Map<String, JavaElementImpl> refs) throws AmbiguousConstructorException {
        for (JavaParameterImpl param : parameters) {
            if (this.findReferenceOrProperty(param, props, refs)) continue;
            throw new AmbiguousConstructorException(param.getName());
        }
    }

    private void heuristicParamNames(JavaImplementation type, JavaParameterImpl[] parameters) throws IntrospectionException {
        for (JavaParameterImpl p : parameters) {
            String name = p.getType().getSimpleName().toLowerCase();
            if (HeuristicPojoProcessor.isReferenceType(p.getType(), p.getGenericType())) {
                type.getReferences().add(this.createReference(name, p.getType(), p.getGenericType()));
                p.setClassifer(org.oasisopen.sca.annotation.Reference.class);
                type.getReferenceMembers().put(name, p);
            } else {
                type.getProperties().add(this.createProperty(name, p.getType(), p.getGenericType()));
                p.setClassifer(Property.class);
                type.getPropertyMembers().put(name, p);
            }
            p.setName(name);
        }
    }

    private boolean calcPropRefUniqueness(Collection<JavaElementImpl> props, Collection<JavaElementImpl> refs) {
        Class[] classes = new Class[props.size() + refs.size()];
        int i = 0;
        for (JavaElementImpl property : props) {
            classes[i] = property.getType();
            ++i;
        }
        for (JavaElementImpl reference : refs) {
            classes[i] = reference.getType();
            ++i;
        }
        return HeuristicPojoProcessor.areUnique(classes);
    }

    private boolean findReferenceOrProperty(JavaParameterImpl parameter, Map<String, JavaElementImpl> props, Map<String, JavaElementImpl> refs) throws AmbiguousConstructorException {
        boolean found = false;
        if (!"".equals(parameter.getName())) {
            JavaElementImpl prop = props.get(parameter.getName());
            if (prop != null && prop.getType() == parameter.getType()) {
                parameter.setClassifer(Property.class);
                return true;
            }
            JavaElementImpl ref = refs.get(parameter.getName());
            if (ref != null && ref.getType() == parameter.getType()) {
                parameter.setClassifer(org.oasisopen.sca.annotation.Reference.class);
                return true;
            }
        }
        for (JavaElementImpl property : props.values()) {
            if (property.getType() != parameter.getType()) continue;
            if (found) {
                throw new AmbiguousConstructorException("Ambiguous property or reference for constructor type", (Member)((Object)parameter.getAnchor()));
            }
            parameter.setClassifer(Property.class);
            parameter.setName(property.getName());
            found = true;
        }
        for (JavaElementImpl reference : refs.values()) {
            if (reference.getType() != parameter.getType()) continue;
            if (found) {
                throw new AmbiguousConstructorException("Ambiguous property or reference for constructor type", (Member)((Object)parameter.getAnchor()));
            }
            parameter.setClassifer(org.oasisopen.sca.annotation.Reference.class);
            parameter.setName(reference.getName());
            found = true;
        }
        return found;
    }

    private org.apache.tuscany.sca.assembly.Property createProperty(String name, Class<?> javaClass, Type genericType) {
        return AbstractPropertyProcessor.createProperty(this.assemblyFactory, name, javaClass, genericType);
    }

    private Reference createReference(String name, Class<?> paramType, Type genericType) throws IntrospectionException {
        Reference reference = this.assemblyFactory.createReference();
        reference.setName(name);
        JavaInterfaceContract interfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        Class<?> baseType = JavaIntrospectionHelper.getBaseType(paramType, genericType);
        if (ServiceReference.class.isAssignableFrom(baseType)) {
            if (Collection.class.isAssignableFrom(paramType)) {
                genericType = JavaIntrospectionHelper.getParameterType(genericType);
            }
            baseType = JavaIntrospectionHelper.getBusinessInterface(baseType, genericType);
        }
        try {
            JavaInterface callInterface = this.javaInterfaceFactory.createJavaInterface(baseType);
            reference.getInterfaceContract().setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                JavaInterface callbackInterface = this.javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass());
                reference.getInterfaceContract().setCallbackInterface(callbackInterface);
            }
            if (this.isCollectionType(paramType) || this.isArrayType(paramType)) {
                reference.setMultiplicity(Multiplicity.ONE_N);
            } else {
                reference.setMultiplicity(Multiplicity.ONE_ONE);
            }
        }
        catch (InvalidInterfaceException e1) {
            throw new IntrospectionException(e1);
        }
        try {
            this.processCallback(paramType, reference);
        }
        catch (InvalidServiceTypeException e) {
            throw new IntrospectionException(e);
        }
        return reference;
    }

    private boolean isCollectionType(Class<?> paramType) {
        return Collection.class.isAssignableFrom(paramType);
    }

    private boolean isArrayType(Class<?> paramType) {
        return paramType.isArray();
    }

    private org.apache.tuscany.sca.assembly.Service createService(Class<?> interfaze) throws InvalidInterfaceException {
        org.apache.tuscany.sca.assembly.Service service = this.assemblyFactory.createService();
        service.setName(interfaze.getSimpleName());
        JavaInterfaceContract interfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        JavaInterface callInterface = this.javaInterfaceFactory.createJavaInterface(interfaze);
        service.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass());
            service.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        Interface javaInterface = service.getInterfaceContract().getInterface();
        javaInterface.setRemotable(interfaze.getAnnotation(Remotable.class) != null);
        service.getInterfaceContract().setInterface(javaInterface);
        return service;
    }

    private void processCallback(Class<?> interfaze, Contract contract) throws InvalidServiceTypeException {
        Callback callback = interfaze.getAnnotation(Callback.class);
        if (callback != null && !Void.class.equals(callback.value())) {
            Class<?> callbackClass = callback.value();
            try {
                JavaInterface javaInterface = this.javaInterfaceFactory.createJavaInterface(callbackClass);
                contract.getInterfaceContract().setCallbackInterface(javaInterface);
            }
            catch (InvalidInterfaceException e) {
                throw new InvalidServiceTypeException("Invalid callback interface " + callbackClass, interfaze);
            }
        } else if (callback != null && Void.class.equals(callback.value())) {
            throw new InvalidServiceTypeException("No callback interface specified on annotation", interfaze);
        }
    }

    private static boolean isPublicSetter(Method method) {
        return method.getParameterTypes().length == 1 && Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE;
    }

    private static boolean isProtectedSetter(Method method) {
        return method.getParameterTypes().length == 1 && Modifier.isProtected(method.getModifiers()) && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE;
    }

    private static boolean areUnique(Class<?>[] collection) {
        HashSet set = new HashSet(Arrays.asList(collection));
        return set.size() == collection.length;
    }

    private static boolean isReferenceType(Class<?> cls, Type genericType) {
        Class<?> baseType = JavaIntrospectionHelper.getBaseType(cls, genericType);
        return baseType.isInterface() && baseType.isAnnotationPresent(Remotable.class);
    }

    private static boolean isInServiceInterface(Method operation, List<org.apache.tuscany.sca.assembly.Service> services) {
        for (org.apache.tuscany.sca.assembly.Service service : services) {
            Class<?> clazz;
            Interface interface1 = service.getInterfaceContract().getInterface();
            if (!(interface1 instanceof JavaInterface) || !HeuristicPojoProcessor.isMethodMatched(clazz = ((JavaInterface)interface1).getJavaClass(), operation)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMethodMatched(Class<?> clazz, Method method) {
        Method[] methods;
        if (method.getDeclaringClass() == clazz) {
            return true;
        }
        for (Method m : methods = clazz.getMethods()) {
            if (!JavaIntrospectionHelper.exactMethodMatch(method, m)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotated(JavaParameterImpl parameter) {
        for (Annotation annotation : parameter.getAnnotations()) {
            if (!HeuristicPojoProcessor.isSCAAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean areUnique(JavaParameterImpl[] parameters) {
        HashSet set = new HashSet(parameters.length);
        for (JavaParameterImpl p : parameters) {
            if (set.add(p.getType())) continue;
            return false;
        }
        return true;
    }

    private static boolean injectionAnnotationsPresent(Annotation[][] annots) {
        Annotation[][] arr$ = annots;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = arr$[i$]) {
                Class<? extends Annotation> annotType = annotation.annotationType();
                if (annotType != Property.class && annotType != org.oasisopen.sca.annotation.Reference.class && annotType != Resource.class && annotType != ComponentName.class && annotType != Context.class && annotType != Callback.class) continue;
                return true;
            }
        }
        return false;
    }
}

