/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicateDestructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalDestructorException;
import org.oasisopen.sca.annotation.Destroy;

public class DestroyProcessor
extends BaseJavaClassVisitor {
    public DestroyProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public DestroyProcessor(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        Destroy annotation = method.getAnnotation(Destroy.class);
        if (annotation == null) {
            return;
        }
        if (method.getParameterTypes().length != 0) {
            throw new IllegalDestructorException("[JCA90004] Destructor must not have arguments", method);
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalDestructorException("Destructor must return void.", method);
        }
        if (type.getDestroyMethod() != null) {
            throw new DuplicateDestructorException("More than one destructor found on implementation");
        }
        type.setDestroyMethod(method);
    }
}

