/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicatePropertyException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalPropertyException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidPropertyException;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.oasisopen.sca.annotation.Property;

public abstract class AbstractPropertyProcessor<A extends Annotation>
extends BaseJavaClassVisitor {
    private final Class<A> annotationClass;

    protected AbstractPropertyProcessor(ExtensionPointRegistry registry, Class<A> annotationClass) {
        super(registry);
        this.annotationClass = annotationClass;
    }

    private static boolean removeProperty(JavaElementImpl prop, JavaImplementation type) {
        if (prop == null) {
            return false;
        }
        List<org.apache.tuscany.sca.assembly.Property> props = type.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            if (!props.get(i).getName().equals(prop.getName())) continue;
            props.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        A annotation = method.getAnnotation(this.annotationClass);
        if (annotation != null) {
            Map<String, JavaElementImpl> properties;
            JavaElementImpl prop;
            if (!JavaIntrospectionHelper.isSetter(method)) {
                throw new IllegalPropertyException("Annotated method is not a setter: " + method, method);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalPropertyException("Static method " + method.getName() + " in class " + method.getDeclaringClass().getName() + " can not be annotated as a Property");
            }
            String name = this.getName(annotation);
            if ((name == null || "".equals(name)) && (name = method.getName()).startsWith("set")) {
                name = JavaIntrospectionHelper.toPropertyName(method.getName());
            }
            if ((prop = (properties = type.getPropertyMembers()).get(name)) != null && prop.getElementType() != ElementType.FIELD) {
                throw new DuplicatePropertyException(name);
            }
            AbstractPropertyProcessor.removeProperty(prop, type);
            JavaElementImpl element = new JavaElementImpl(method, 0);
            org.apache.tuscany.sca.assembly.Property property = this.createProperty(name, element);
            this.initProperty(property, annotation);
            type.getProperties().add(property);
            properties.put(name, element);
        }
        Annotation[][] paramsAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < paramsAnnotations.length; ++i) {
            Annotation[] argAnnotations = paramsAnnotations[i];
            for (int j = 0; j < argAnnotations.length; ++j) {
                if (argAnnotations[j].annotationType() != Property.class) continue;
                throw new IllegalPropertyException("[JCA90001] Argument " + (i + 1) + " of method " + method.getName() + " in class " + method.getDeclaringClass() + " can not be a Property");
            }
        }
    }

    @Override
    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        Map<String, JavaElementImpl> properties;
        JavaElementImpl prop;
        A annotation = field.getAnnotation(this.annotationClass);
        if (annotation == null) {
            return;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalPropertyException("Static field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " can not be annotated as a Property");
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new IllegalPropertyException("[JCA90011] Final field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " can not be annotated as a Property");
        }
        String name = this.getName(annotation);
        if (name == null) {
            name = "";
        }
        if ("".equals(name) || name.equals(field.getType().getName())) {
            name = field.getName();
        }
        if ((prop = (properties = type.getPropertyMembers()).get(name)) != null && prop.getElementType() == ElementType.FIELD) {
            throw new DuplicatePropertyException(name);
        }
        if (prop == null) {
            JavaElementImpl element = new JavaElementImpl(field);
            org.apache.tuscany.sca.assembly.Property property = this.createProperty(name, element);
            this.initProperty(property, annotation);
            type.getProperties().add(property);
            properties.put(name, element);
        }
    }

    @Override
    public void visitConstructorParameter(JavaParameterImpl parameter, JavaImplementation type) throws IntrospectionException {
        Map<String, JavaElementImpl> properties = type.getPropertyMembers();
        A annotation = parameter.getAnnotation(this.annotationClass);
        if (annotation != null) {
            String name = this.getName(annotation);
            if (name == null) {
                name = parameter.getType().getName();
            }
            if (!("".equals(name) || "".equals(parameter.getName()) || name.equals(parameter.getName()))) {
                throw new InvalidConstructorException("Mismatched property name: " + parameter);
            }
            if ("".equals(name) && "".equals(parameter.getName())) {
                throw new InvalidPropertyException("[JCA90013] Missing property name: " + parameter);
            }
            if ("".equals(name)) {
                name = parameter.getName();
            }
            if (!this.getRequired(annotation)) {
                throw new InvalidPropertyException("[JCA90014] Constructor property must not have required=false: " + type.getName());
            }
            JavaElementImpl prop = properties.get(name);
            if (prop != null && prop.getElementType() != ElementType.FIELD) {
                throw new DuplicatePropertyException(name);
            }
            AbstractPropertyProcessor.removeProperty(prop, type);
            parameter.setName(name);
            parameter.setClassifer(this.annotationClass);
            org.apache.tuscany.sca.assembly.Property property = this.createProperty(name, parameter);
            this.initProperty(property, annotation);
            type.getProperties().add(property);
            properties.put(name, parameter);
        }
    }

    protected org.apache.tuscany.sca.assembly.Property createProperty(String name, JavaElementImpl element) throws IntrospectionException {
        Type type = element.getGenericType();
        Class<?> javaType = element.getType();
        return AbstractPropertyProcessor.createProperty(this.assemblyFactory, name, javaType, type);
    }

    public static org.apache.tuscany.sca.assembly.Property createProperty(AssemblyFactory assemblyFactory, String name, Class<?> javaClass, Type genericType) {
        org.apache.tuscany.sca.assembly.Property property = assemblyFactory.createProperty();
        property.setName(name);
        if (javaClass.isArray() || Collection.class.isAssignableFrom(javaClass)) {
            property.setMany(true);
            if (javaClass.isArray()) {
                Class<?> propType;
                Type genericPropType = propType = javaClass.getComponentType();
                if (genericType instanceof GenericArrayType) {
                    genericPropType = ((GenericArrayType)genericType).getGenericComponentType();
                }
                DataTypeImpl<XMLType> dt = new DataTypeImpl<XMLType>(null, propType, genericPropType, XMLType.UNKNOWN);
                property.setDataType(dt);
            } else if (genericType instanceof ParameterizedType) {
                Type genericPropType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                Class<?> propType = JavaIntrospectionHelper.getErasure(genericPropType);
                DataTypeImpl<XMLType> dt = new DataTypeImpl<XMLType>(null, propType, genericPropType, XMLType.UNKNOWN);
                property.setDataType(dt);
            } else {
                DataTypeImpl<XMLType> dt = new DataTypeImpl<XMLType>(null, Object.class, (Type)((Object)Object.class), XMLType.UNKNOWN);
                property.setDataType(dt);
            }
        } else {
            DataTypeImpl<XMLType> dt = new DataTypeImpl<XMLType>(null, javaClass, genericType, XMLType.UNKNOWN);
            property.setDataType(dt);
        }
        return property;
    }

    protected abstract String getName(A var1);

    protected abstract boolean getRequired(A var1);

    protected abstract void initProperty(org.apache.tuscany.sca.assembly.Property var1, A var2) throws IntrospectionException;
}

