/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.Injector;

public class FieldInjector<T>
implements Injector<T> {
    private final Field field;
    private final ObjectFactory<?> objectFactory;

    public FieldInjector(Field pField, ObjectFactory<?> objectFactory) {
        this.field = pField;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FieldInjector.this.field.setAccessible(true);
                return null;
            }
        });
        this.objectFactory = objectFactory;
    }

    @Override
    public void inject(T instance) throws ObjectCreationException {
        this.inject(instance, this.objectFactory.getInstance());
    }

    public void inject(T instance, Object value) {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new ObjectCreationException("Field is not accessible [" + this.field + "]", e);
        }
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public Type getGenericType() {
        return this.field.getGenericType();
    }

    @Override
    public void injectNull(T instance) throws ObjectCreationException {
        this.inject(instance, null);
    }
}

