/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.xml;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.bpel.BPELFactory;
import org.apache.tuscany.sca.implementation.bpel.BPELProcessDefinition;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELImportElement;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELPartnerLinkElement;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELProcessorConstants;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class BPELDocumentProcessor
extends BaseStAXArtifactProcessor
implements URLArtifactProcessor<BPELProcessDefinition> {
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final BPELFactory factory;
    private WSDLFactory WSDLfactory;
    private AssemblyFactory assemblyFactory;

    public BPELDocumentProcessor(FactoryExtensionPoint modelFactories) {
        this.factory = modelFactories.getFactory(BPELFactory.class);
        this.WSDLfactory = modelFactories.getFactory(WSDLFactory.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
    }

    @Override
    public String getArtifactType() {
        return "*.bpel";
    }

    @Override
    public Class<BPELProcessDefinition> getModelType() {
        return BPELProcessDefinition.class;
    }

    @Override
    public BPELProcessDefinition read(URL contributionURL, URI artifactURI, URL artifactURL, ProcessorContext context) throws ContributionReadException {
        BPELProcessDefinition processDefinition = null;
        try {
            processDefinition = this.readProcessDefinition(artifactURL, context.getMonitor());
            processDefinition.setURI(artifactURI.toString());
            processDefinition.setUnresolved(true);
        }
        catch (Exception e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error(context.getMonitor(), "ContributionReadException", (Object)artifactURL, ce);
        }
        return processDefinition;
    }

    @Override
    public void resolve(BPELProcessDefinition model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (model != null || model.isUnresolved()) {
            resolver.resolveModel(BPELProcessDefinition.class, model, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BPELProcessDefinition readProcessDefinition(URL doc, Monitor monitor) throws Exception {
        BPELProcessDefinition processDefinition = this.factory.createBPELProcessDefinition();
        processDefinition.setUnresolved(true);
        processDefinition.setLocation(doc.toString());
        InputStream is = doc.openStream();
        XMLStreamReader reader = null;
        try {
            reader = inputFactory.createXMLStreamReader(is);
            boolean completed = false;
            block7: while (!completed) {
                switch (reader.next()) {
                    case 1: {
                        QName qname = reader.getName();
                        if (BPELProcessorConstants.PROCESS_ELEMENT.equals(qname) || BPELProcessorConstants.PROCESS_ELEMENT_20.equals(qname)) {
                            QName processName = new QName(this.getString(reader, "targetNamespace"), this.getString(reader, "name"));
                            processDefinition.setName(processName);
                            break;
                        }
                        if (BPELProcessorConstants.PARTNERLINK_ELEMENT.equals(qname) || BPELProcessorConstants.PARTNERLINK_ELEMENT_20.equals(qname)) {
                            processDefinition.getPartnerLinks().add(this.processPartnerLinkElement(reader, monitor));
                            break;
                        }
                        if (BPELProcessorConstants.ONEVENT_ELEMENT.equals(qname) || BPELProcessorConstants.RECEIVE_ELEMENT.equals(qname) || BPELProcessorConstants.ONMESSAGE_ELEMENT.equals(qname) || BPELProcessorConstants.ONEVENT_ELEMENT_20.equals(qname) || BPELProcessorConstants.RECEIVE_ELEMENT_20.equals(qname) || BPELProcessorConstants.ONMESSAGE_ELEMENT_20.equals(qname)) {
                            this.processPartnerLinkAsService(reader.getAttributeValue(null, "partnerLink"), processDefinition.getPartnerLinks(), monitor);
                            break;
                        }
                        if (BPELProcessorConstants.INVOKE_ELEMENT.equals(qname) || BPELProcessorConstants.INVOKE_ELEMENT_20.equals(qname)) {
                            this.processPartnerLinkAsReference(reader.getAttributeValue(null, "partnerLink"), processDefinition.getPartnerLinks(), monitor);
                            break;
                        }
                        if (BPELProcessorConstants.IMPORT_ELEMENT.equals(qname) || BPELProcessorConstants.IMPORT_ELEMENT_20.equals(qname)) {
                            processDefinition.getImports().add(this.processImportElement(reader));
                            break;
                        }
                        if (!BPELProcessorConstants.VARIABLE_ELEMENT.equals(qname) && !BPELProcessorConstants.VARIABLE_ELEMENT_20.equals(qname)) break;
                        Property aProperty = this.processVariableElement(reader);
                        if (aProperty == null) continue block7;
                        processDefinition.getProperties().add(aProperty);
                        break;
                    }
                    case 2: {
                        QName qname = reader.getName();
                        if (!BPELProcessorConstants.PROCESS_ELEMENT.equals(qname) && !BPELProcessorConstants.PROCESS_ELEMENT_20.equals(qname)) break;
                        completed = true;
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            is.close();
        }
        return processDefinition;
    }

    private Property processVariableElement(XMLStreamReader reader) throws ContributionReadException {
        String scaProperty = reader.getAttributeValue("http://docs.oasis-open.org/ns/opencsa/sca-bpel/200801", "property");
        if ("yes".equals(scaProperty)) {
            String varName = reader.getAttributeValue(null, "name");
            String varType = reader.getAttributeValue(null, "type");
            String varElement = reader.getAttributeValue(null, "element");
            String varMessage = reader.getAttributeValue(null, "message");
            if (varName == null) {
                return null;
            }
            if (varType == null && varElement == null && varMessage == null) {
                return null;
            }
            QName typeQName = this.getQNameValue(reader, varType);
            QName elementQName = this.getQNameValue(reader, varElement);
            Property theProperty = this.assemblyFactory.createProperty();
            theProperty.setName(varName);
            theProperty.setXSDType(typeQName);
            theProperty.setXSDElement(elementQName);
            return theProperty;
        }
        return null;
    }

    private BPELPartnerLinkElement processPartnerLinkElement(XMLStreamReader reader, Monitor monitor) throws ContributionReadException {
        BPELPartnerLinkElement partnerLink = new BPELPartnerLinkElement(reader.getAttributeValue(null, "name"), this.getQNameValue(reader, reader.getAttributeValue(null, "partnerLinkType")), reader.getAttributeValue(null, "myRole"), reader.getAttributeValue(null, "partnerRole"));
        String scaService = reader.getAttributeValue("http://docs.oasis-open.org/ns/opencsa/sca-bpel/200801", "service");
        String scaReference = reader.getAttributeValue("http://docs.oasis-open.org/ns/opencsa/sca-bpel/200801", "reference");
        if (scaService != null && scaReference != null) {
            this.error(monitor, "PartnerLinkHasBothAttr", (Object)partnerLink, reader.getAttributeValue(null, "name"));
            throw new ContributionReadException("BPEL PartnerLink " + reader.getAttributeValue(null, "name") + " has both sca:reference and sca:service attributes set");
        }
        if (scaService != null) {
            partnerLink.setAsService(scaService);
        } else if (scaReference != null) {
            partnerLink.setAsReference(scaReference);
        }
        return partnerLink;
    }

    private BPELImportElement processImportElement(XMLStreamReader reader) {
        return new BPELImportElement(reader.getAttributeValue(null, "location"), reader.getAttributeValue(null, "importType"), reader.getAttributeValue(null, "namespace"));
    }

    private void processPartnerLinkAsService(String partnerLinkName, List<BPELPartnerLinkElement> partnerLinks, Monitor monitor) {
        BPELPartnerLinkElement partnerLink = this.findPartnerLinkByName(partnerLinks, partnerLinkName);
        if (partnerLink == null) {
            this.warning(monitor, "ReferencePartnerLinkNotInList", partnerLinkName, partnerLinkName);
        } else if (!partnerLink.isSCATyped()) {
            partnerLink.setAsService(partnerLinkName);
        }
    }

    private void processPartnerLinkAsReference(String partnerLinkName, List<BPELPartnerLinkElement> partnerLinks, Monitor monitor) {
        BPELPartnerLinkElement partnerLink = this.findPartnerLinkByName(partnerLinks, partnerLinkName);
        if (partnerLink == null) {
            this.warning(monitor, "ReferencePartnerLinkNotInList", partnerLinkName, partnerLinkName);
        } else if (!partnerLink.isSCATyped()) {
            partnerLink.setAsReference(partnerLinkName);
        }
    }

    private BPELPartnerLinkElement findPartnerLinkByName(List<BPELPartnerLinkElement> partnerLinks, String partnerLinkName) {
        for (BPELPartnerLinkElement thePartnerLink : partnerLinks) {
            if (!thePartnerLink.getName().equals(partnerLinkName)) continue;
            return thePartnerLink;
        }
        return null;
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }
}

