/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.xml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.bpel.BPELProcessDefinition;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELImportElement;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELPartnerLinkElement;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELPartnerLinkTypeElement;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELProcessorConstants;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.wsdl.BPELPartnerLinkTypeExt;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class BPELDocumentModelResolver
implements ModelResolver {
    private WSDLFactory wsdlFactory;
    private Contribution contribution;
    private Map<QName, BPELProcessDefinition> map = new HashMap<QName, BPELProcessDefinition>();

    public BPELDocumentModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) {
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.contribution = contribution;
    }

    @Override
    public void addModel(Object resolved, ProcessorContext context) {
        BPELProcessDefinition process = (BPELProcessDefinition)resolved;
        this.map.put(process.getName(), process);
    }

    @Override
    public Object removeModel(Object resolved, ProcessorContext context) {
        return this.map.remove(((BPELProcessDefinition)resolved).getName());
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        NamespaceImport namespaceImport;
        BPELProcessDefinition resolved = null;
        QName qname = ((BPELProcessDefinition)unresolved).getName();
        ArrayList<String> locations = new ArrayList<String>();
        HashMap locationMap = new HashMap();
        for (Import import_ : this.contribution.getImports()) {
            if (!(import_ instanceof NamespaceImport) || !(namespaceImport = (NamespaceImport)import_).getNamespace().equals(qname.getNamespaceURI())) continue;
            if (namespaceImport.getLocation() == null) {
                resolved = namespaceImport.getModelResolver().resolveModel(BPELProcessDefinition.class, (BPELProcessDefinition)unresolved, context);
                if (resolved.isUnresolved()) continue;
                return modelClass.cast(resolved);
            }
            locations.add(namespaceImport.getLocation());
        }
        Collections.sort(locations);
        for (String location : locations) {
            namespaceImport = (NamespaceImport)locationMap.get(location);
            resolved = namespaceImport.getModelResolver().resolveModel(BPELProcessDefinition.class, (BPELProcessDefinition)unresolved, context);
            if (resolved.isUnresolved()) continue;
            return modelClass.cast(resolved);
        }
        resolved = this.map.get(qname);
        if (resolved != null && resolved.isUnresolved()) {
            try {
                this.resolve(resolved, context);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        return unresolved;
    }

    public void resolve(BPELProcessDefinition unresolved, ProcessorContext context) throws ContributionResolveException {
        List<BPELImportElement> theImports = unresolved.getImports();
        Set<Definition> wsdlDefinitions = this.getImportedWSDLDefinitions(theImports, this.contribution.getModelResolver(), context);
        List<BPELPartnerLinkTypeElement> thePLinkTypes = this.getPartnerLinkTypes(wsdlDefinitions, context.getMonitor());
        ArrayList<WSDLInterface> theInterfaces = new ArrayList<WSDLInterface>();
        Collection<PortType> thePortTypes = this.getAllPortTypes(theImports, theInterfaces, this.contribution.getModelResolver(), context);
        unresolved.getPortTypes().addAll(thePortTypes);
        unresolved.getInterfaces().addAll(theInterfaces);
        List<BPELPartnerLinkElement> thePartnerLinks = unresolved.getPartnerLinks();
        for (BPELPartnerLinkElement thePartnerLink : thePartnerLinks) {
            QName partnerLinkType = thePartnerLink.getPartnerLinkType();
            BPELPartnerLinkTypeElement pLinkType = this.findPartnerLinkType(partnerLinkType, thePLinkTypes);
            if (pLinkType == null) {
                this.error(context.getMonitor(), "PartnerLinkNoMatchingType", (Object)thePartnerLink, thePartnerLink.getName());
                continue;
            }
            thePartnerLink.setPartnerLinkType(pLinkType);
        }
        unresolved.setUnresolved(false);
    }

    private Set<Definition> getImportedWSDLDefinitions(List<BPELImportElement> theImports, ModelResolver resolver, ProcessorContext context) {
        HashSet<Definition> wsdlDefinitions = null;
        for (BPELImportElement theImport : theImports) {
            WSDLDefinition theWSDL;
            if (!theImport.getImportType().equals("http://schemas.xmlsoap.org/wsdl/") || (theWSDL = this.resolveWSDLDefinition(theImport.getLocation(), theImport.getNamespace(), resolver, context)) == null) continue;
            theImport.setWSDLDefinition(theWSDL);
            if (wsdlDefinitions == null) {
                wsdlDefinitions = new HashSet<Definition>();
            }
            wsdlDefinitions.add(theWSDL.getDefinition());
        }
        return wsdlDefinitions;
    }

    private WSDLDefinition resolveWSDLDefinition(String wsdlLocation, String wsdlNamespace, ModelResolver resolver, ProcessorContext context) {
        WSDLDefinition resolved;
        WSDLDefinition proxy = this.wsdlFactory.createWSDLDefinition();
        proxy.setUnresolved(true);
        proxy.setNamespace(wsdlNamespace);
        if (wsdlLocation != null) {
            proxy.setLocation(URI.create(wsdlLocation));
        }
        if ((resolved = resolver.resolveModel(WSDLDefinition.class, proxy, context)) != null && !resolved.isUnresolved()) {
            return resolved;
        }
        this.error(context.getMonitor(), "CannotResolveWSDLReference", (Object)resolver, wsdlLocation, wsdlNamespace);
        return null;
    }

    private List<BPELPartnerLinkTypeElement> getPartnerLinkTypes(Set<Definition> wsdlDefinitions, Monitor monitor) throws ContributionResolveException {
        ArrayList<BPELPartnerLinkTypeElement> thePLinks = new ArrayList<BPELPartnerLinkTypeElement>();
        for (Definition wsdlDefinition : wsdlDefinitions) {
            for (ExtensibilityElement theElement : wsdlDefinition.getExtensibilityElements()) {
                QName elementType = theElement.getElementType();
                if (!elementType.equals(BPELProcessorConstants.LINKTYPE_ELEMENT) && !elementType.equals(BPELProcessorConstants.LINKTYPE_ELEMENT_20)) continue;
                BPELPartnerLinkTypeExt pLinkExt = (BPELPartnerLinkTypeExt)theElement;
                QName qName = new QName(wsdlDefinition.getTargetNamespace(), pLinkExt.getName());
                BPELPartnerLinkTypeElement pLinkElement = new BPELPartnerLinkTypeElement(qName);
                int count = 0;
                for (int i = 0; i < 2 && count <= 1; ++i) {
                    if (pLinkExt.getRoleName(i) == null) continue;
                    PortType pType = wsdlDefinition.getPortType(pLinkExt.getRolePortType(i));
                    if (count == 0) {
                        pLinkElement.setRole1(pLinkExt.getRoleName(i), pLinkExt.getRolePortType(i), pType);
                    } else {
                        pLinkElement.setRole2(pLinkExt.getRoleName(i), pLinkExt.getRolePortType(i), pType);
                    }
                    ++count;
                }
                if (count == 0) {
                    this.error(monitor, "PartnerLinkTypeNoRoles", (Object)theElement, pLinkElement.getName());
                    throw new ContributionResolveException("partnerLinkType " + pLinkElement.getName() + " has no Roles defined");
                }
                thePLinks.add(pLinkElement);
            }
        }
        return thePLinks;
    }

    private BPELPartnerLinkTypeElement findPartnerLinkType(QName partnerLinkTypeName, List<BPELPartnerLinkTypeElement> thePLinkTypes) {
        for (BPELPartnerLinkTypeElement thePLinkType : thePLinkTypes) {
            if (!thePLinkType.getName().equals(partnerLinkTypeName)) continue;
            return thePLinkType;
        }
        return null;
    }

    private Collection<PortType> getAllPortTypes(List<BPELImportElement> theImports, Collection<WSDLInterface> theInterfaces, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        HashSet<PortType> thePortTypes = new HashSet<PortType>();
        for (BPELImportElement theImport : theImports) {
            if (!theImport.getImportType().equals("http://schemas.xmlsoap.org/wsdl/")) continue;
            ArrayList<Definition> wsdlDefinitions = new ArrayList<Definition>();
            WSDLDefinition theWSDL = theImport.getWSDLDefinition();
            wsdlDefinitions.add(theWSDL.getDefinition());
            for (WSDLDefinition importedWSDL : theWSDL.getImportedDefinitions()) {
                wsdlDefinitions.add(importedWSDL.getDefinition());
            }
            for (Definition wsdlDefinition : wsdlDefinitions) {
                Collection portTypes = wsdlDefinition.getPortTypes().values();
                for (PortType portType : portTypes) {
                    WSDLInterface wsdlInterface;
                    if (thePortTypes.contains(portType)) continue;
                    thePortTypes.add(portType);
                    WSDLObject<PortType> wsdlPortType = theWSDL.getWSDLObject(PortType.class, portType.getQName());
                    if (wsdlPortType == null) continue;
                    try {
                        wsdlInterface = this.wsdlFactory.createWSDLInterface(wsdlPortType.getElement(), theWSDL, resolver, context.getMonitor());
                        wsdlInterface.setWsdlDefinition(theWSDL);
                    }
                    catch (InvalidInterfaceException e) {
                        ContributionResolveException ce = new ContributionResolveException("Unable to create WSDLInterface for portType " + portType.getQName(), e);
                        this.error(context.getMonitor(), "ContributionResolveException", (Object)resolver, ce);
                        throw ce;
                    }
                    resolver.addModel(wsdlInterface, context);
                    theInterfaces.add(wsdlInterface);
                }
            }
        }
        return thePortTypes;
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }
}

