/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.impl.CompositeImpl;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.ValidationException;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.DomainRegistry;

public class DeployedComposite {
    private Composite composite;
    private Contribution contribution;
    private List<Contribution> dependedOnContributions;
    private Composite builtComposite;
    private CompositeActivator compositeActivator;
    private CompositeContext compositeContext;
    private Deployer deployer;
    private DomainRegistry domainRegistry;
    private ExtensionPointRegistry extensionPointRegistry;
    private List<String> usedContributionURIs;
    private boolean endpointsIncludeDomainName;

    public DeployedComposite(Composite composite, Contribution contribution, List<Contribution> dependedOnContributions, Deployer deployer, CompositeActivator compositeActivator, DomainRegistry domainRegistry, ExtensionPointRegistry extensionPointRegistry, boolean endpointsIncludeDomainName) throws ValidationException, ActivationException {
        this.composite = composite;
        this.contribution = contribution;
        this.dependedOnContributions = dependedOnContributions;
        this.deployer = deployer;
        this.compositeActivator = compositeActivator;
        this.domainRegistry = domainRegistry;
        this.extensionPointRegistry = extensionPointRegistry;
        this.endpointsIncludeDomainName = endpointsIncludeDomainName;
        try {
            this.build();
        }
        catch (ContributionResolveException e) {
            throw new ActivationException(e);
        }
        catch (CompositeBuilderException e) {
            throw new ActivationException(e);
        }
    }

    protected void build() throws ValidationException, ActivationException, ContributionResolveException, CompositeBuilderException {
        ModelResolver o;
        ArrayList<Contribution> contributions = new ArrayList<Contribution>();
        contributions.add(this.contribution);
        ((Contribution)contributions.get(0)).getDeployables().clear();
        ((Contribution)contributions.get(0)).getDeployables().add(this.composite);
        contributions.addAll(this.dependedOnContributions);
        HashMap<QName, List<String>> bs = new HashMap<QName, List<String>>();
        if (this.endpointsIncludeDomainName) {
            bs.put(new QName("default"), Arrays.asList(this.domainRegistry.getDomainName()));
        }
        Monitor monitor = this.deployer.createMonitor();
        this.builtComposite = this.deployer.build(contributions, contributions, bs, monitor);
        monitor.analyzeProblems();
        this.builtComposite.setName(this.composite.getName());
        this.builtComposite.setURI(this.composite.getURI());
        this.builtComposite.setContributionURI(this.composite.getContributionURI());
        if (this.contribution.getClassLoader() == null && this.contribution.getModelResolver() instanceof ExtensibleModelResolver && (o = ((ExtensibleModelResolver)this.contribution.getModelResolver()).getModelResolverInstance(ClassReference.class)) instanceof ClassLoader) {
            this.contribution.setClassLoader((ClassLoader)((Object)o));
        }
        this.compositeContext = new CompositeContext(this.extensionPointRegistry, this.domainRegistry, this.builtComposite, null, null, this.deployer.getSystemDefinitions());
        this.usedContributionURIs = new ArrayList<String>();
        this.usedContributionURIs.add(this.contribution.getURI());
        for (Contribution dc : this.dependedOnContributions) {
            this.usedContributionURIs.add(dc.getURI());
        }
    }

    public void start() throws ActivationException {
        try {
            this.compositeActivator.activate(this.compositeContext, this.builtComposite);
            this.compositeActivator.start(this.compositeContext, this.builtComposite);
            this.domainRegistry.addRunningComposite(this.contribution.getURI(), this.builtComposite);
        }
        catch (ActivationException ex) {
            this.stop();
            throw ex;
        }
        catch (Exception ex) {
            this.stop();
            throw new ActivationException(ex);
        }
    }

    public void stop() throws ActivationException {
        this.domainRegistry.removeRunningComposite(this.contribution.getURI(), this.builtComposite.getURI());
        this.compositeActivator.stop(this.compositeContext, this.builtComposite);
        this.compositeActivator.deactivate(this.builtComposite);
    }

    public String getURI() {
        return this.composite.getURI();
    }

    public List<String> getContributionURIs() {
        return this.usedContributionURIs;
    }

    public boolean uses(String contributionURI, String compositeURI) {
        return this.compositeUses(this.builtComposite, contributionURI, compositeURI);
    }

    protected boolean compositeUses(Composite c, String contributionURI, String compositeURI) {
        if (contributionURI.equals(c.getContributionURI()) && compositeURI.equals(c.getURI())) {
            return true;
        }
        for (Composite include : ((CompositeImpl)c).getFusedIncludes()) {
            if (!this.compositeUses(include, contributionURI, compositeURI)) continue;
            return true;
        }
        for (Component comp : c.getComponents()) {
            if (!(comp.getImplementation() instanceof Composite) || !this.compositeUses((Composite)comp.getImplementation(), contributionURI, compositeURI)) continue;
            return true;
        }
        return false;
    }
}

