/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.jetty;

import java.util.logging.Level;
import org.mortbay.log.Logger;

public class JettyLogger
implements Logger {
    private java.util.logging.Logger jdkLogger;

    public JettyLogger() {
        this(JettyLogger.class.getName());
    }

    public JettyLogger(String name) {
        this.jdkLogger = java.util.logging.Logger.getLogger(name);
    }

    public JettyLogger(java.util.logging.Logger jdkLogger) {
        this.jdkLogger = jdkLogger;
    }

    public String getName() {
        return this.jdkLogger.getName();
    }

    public void debug(String msg) {
        this.jdkLogger.log(Level.FINE, msg);
    }

    public void debug(String msg, Throwable th) {
        this.jdkLogger.log(Level.FINE, msg, th);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        this.jdkLogger.log(Level.FINE, this.format(msg, arg0, arg1));
    }

    public Logger getLogger(String name) {
        return new JettyLogger(name);
    }

    public void info(String msg) {
        this.jdkLogger.log(Level.INFO, msg);
    }

    public void info(String msg, Object arg0, Object arg1) {
        this.jdkLogger.log(Level.INFO, this.format(msg, arg0, arg1));
    }

    public boolean isDebugEnabled() {
        return this.jdkLogger.isLoggable(Level.FINE);
    }

    public void setDebugEnabled(boolean enabled) {
        this.jdkLogger.setLevel(Level.FINE);
    }

    public void warn(String msg) {
        this.jdkLogger.log(Level.WARNING, msg);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        this.jdkLogger.log(Level.WARNING, this.format(msg, arg0, arg1));
    }

    public void warn(String msg, Throwable th) {
        this.jdkLogger.log(Level.WARNING, msg, th);
    }

    private String format(String msg, Object arg0, Object arg1) {
        int i1;
        int i0 = msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (arg1 != null && i1 >= 0) {
            msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
        }
        if (arg0 != null && i0 >= 0) {
            msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
        }
        return msg;
    }
}

