/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.tuscany.sca.host.webapp.WebAppHelper;
import org.apache.tuscany.sca.host.webapp.WebContextConfigurator;
import org.apache.tuscany.sca.node.Node;

public class TuscanyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(TuscanyServlet.class.getName());
    private transient WebContextConfigurator configurator;
    private transient Node node;

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            this.configurator = WebAppHelper.getConfigurator((Servlet)this);
            this.node = WebAppHelper.init(this.configurator);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.configurator.getServletContext().log(e.getMessage(), e);
            throw new ServletException(e);
        }
    }

    public void destroy() {
        WebAppHelper.stop(this.configurator);
        this.node = null;
        this.configurator = null;
        super.destroy();
    }

    public Node getNode() {
        return this.node;
    }
}

