/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.tuscany.sca.host.webapp.WebAppHelper;
import org.apache.tuscany.sca.host.webapp.WebContextConfigurator;

public class TuscanyContextListener
implements ServletContextListener {
    private final Logger logger = Logger.getLogger(TuscanyContextListener.class.getName());
    private boolean inited;

    public void contextInitialized(ServletContextEvent event) {
        this.logger.info(event.getServletContext().getServletContextName() + " is starting.");
        try {
            WebContextConfigurator configurator = WebAppHelper.getConfigurator(event.getServletContext());
            WebAppHelper.init(configurator);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.inited = true;
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.logger.info(event.getServletContext().getServletContextName() + " is stopping.");
        if (!this.inited) {
            return;
        }
        try {
            WebContextConfigurator configurator = WebAppHelper.getConfigurator(event.getServletContext());
            WebAppHelper.stop(configurator);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.inited = false;
    }
}

