/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.http.client;

import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;

public class HttpClientFactory
implements LifeCycleListener {
    private HttpClient httpClient;

    public static HttpClientFactory getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        return utilities.getUtility(HttpClientFactory.class);
    }

    public HttpClient createHttpClient() {
        BasicHttpParams defaultParameters = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)defaultParameters, (int)1024);
        ConnPerRouteBean connPerRoute = new ConnPerRouteBean(256);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)defaultParameters, (ConnPerRoute)connPerRoute);
        HttpProtocolParams.setContentCharset((HttpParams)defaultParameters, (String)"UTF-8");
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultParameters, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)defaultParameters, (int)60000);
        SchemeRegistry supportedSchemes = new SchemeRegistry();
        supportedSchemes.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        supportedSchemes.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager((HttpParams)defaultParameters, supportedSchemes);
        return new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)defaultParameters);
    }

    @Override
    public void start() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
    }

    @Override
    public void stop() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
            this.httpClient = null;
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

