/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;

public class ServiceDeclarationParser {
    private static final String PATH_SEPARATOR = "|";
    private static final String SEGMENT_SEPARATOR = ";,";
    private static final String ATTRIBUTE_SEPARATOR = "=";
    private static final String DIRECTIVE_SEPARATOR = ":=";
    private static final char QUOTE_CHAR = '\"';
    private static final String QUOTE = "\"";

    public static List<Descriptor> parse(String header) {
        if (header != null) {
            if (header.length() == 0) {
                throw new IllegalArgumentException("A header cannot be an empty string.");
            }
            String[] clauseStrings = ServiceDeclarationParser.parseDelimitedString(header, PATH_SEPARATOR);
            ArrayList<Descriptor> completeList = new ArrayList<Descriptor>();
            for (int i = 0; clauseStrings != null && i < clauseStrings.length; ++i) {
                completeList.add(ServiceDeclarationParser.parseClause(clauseStrings[i]));
            }
            return completeList;
        }
        return null;
    }

    public static Map<String, String> parseDeclaration(String declaration) {
        List<Descriptor> descriptors = ServiceDeclarationParser.parse(declaration);
        Descriptor descriptor = descriptors.get(0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(descriptor.getAttributes());
        map.put("class", descriptor.getValue());
        for (Map.Entry<String, String> e : descriptor.getDirectives().entrySet()) {
            map.put("@" + e.getKey(), e.getValue());
        }
        return map;
    }

    private static Descriptor parseClause(String clauseString) throws IllegalArgumentException {
        String[] pieces = ServiceDeclarationParser.parseDelimitedString(clauseString, SEGMENT_SEPARATOR);
        int pathCount = 0;
        for (int pieceIdx = 0; pieceIdx < pieces.length && pieces[pieceIdx].indexOf(61) < 0; ++pieceIdx) {
            ++pathCount;
        }
        String[] paths = new String[pathCount];
        System.arraycopy(pieces, 0, paths, 0, pathCount);
        HashMap<String, String> dirsMap = new HashMap<String, String>();
        HashMap<String, String> attrsMap = new HashMap<String, String>();
        int idx = -1;
        String sep = null;
        for (int pieceIdx = pathCount; pieceIdx < pieces.length; ++pieceIdx) {
            idx = pieces[pieceIdx].indexOf(DIRECTIVE_SEPARATOR);
            if (idx >= 0) {
                sep = DIRECTIVE_SEPARATOR;
            } else {
                idx = pieces[pieceIdx].indexOf(ATTRIBUTE_SEPARATOR);
                if (idx >= 0) {
                    sep = ATTRIBUTE_SEPARATOR;
                } else {
                    throw new IllegalArgumentException("Not a directive/attribute: " + clauseString);
                }
            }
            String key = pieces[pieceIdx].substring(0, idx).trim();
            String value = pieces[pieceIdx].substring(idx + sep.length()).trim();
            if (value.startsWith(QUOTE) && value.endsWith(QUOTE)) {
                value = value.substring(1, value.length() - 1);
            }
            if (sep.equals(DIRECTIVE_SEPARATOR)) {
                if (dirsMap.get(key) != null) {
                    throw new IllegalArgumentException("Duplicate directive: " + key);
                }
                dirsMap.put(key, value);
                continue;
            }
            if (attrsMap.get(key) != null) {
                throw new IllegalArgumentException("Duplicate attribute: " + key);
            }
            attrsMap.put(key, value);
        }
        StringBuffer path = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            path.append(paths[i]);
            if (i == paths.length - 1) continue;
            path.append(';');
        }
        Descriptor descriptor = new Descriptor();
        descriptor.text = clauseString;
        descriptor.value = path.toString();
        Descriptor.access$202(descriptor, paths);
        descriptor.attributes = attrsMap;
        descriptor.directives = dirsMap;
        return descriptor;
    }

    private static String[] parseDelimitedString(String value, String delim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    public static QName getQName(String qname) {
        if (qname == null) {
            return null;
        }
        if ((qname = qname.trim()).startsWith("{")) {
            int h = qname.indexOf(125);
            if (h != -1) {
                return new QName(qname.substring(1, h), qname.substring(h + 1));
            }
        } else {
            int h = qname.indexOf(35);
            if (h != -1) {
                return new QName(qname.substring(0, h), qname.substring(h + 1));
            }
        }
        return new QName(qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Map<String, String>> load(final URL url, boolean isPropertyFile) throws IOException {
        InputStream is;
        ArrayList<Map<String, String>> descriptors = new ArrayList<Map<String, String>>();
        try {
            is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    URLConnection connection = url.openConnection();
                    connection.setDefaultUseCaches(false);
                    connection.setUseCaches(false);
                    return url.openStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (isPropertyFile) {
            Properties props = new Properties();
            props.load(is);
            is.close();
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                if (value == null || "".equals(value)) {
                    value = key;
                    key = "";
                }
                if (!"".equals(key)) {
                    attributes.put(key, value);
                    attributes.put("uri", key);
                }
                attributes.putAll(ServiceDeclarationParser.parseDeclaration(value));
                descriptors.add(attributes);
            }
            return descriptors;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || "".equals(line)) continue;
                String reg = line.trim();
                Map<String, String> attributes = ServiceDeclarationParser.parseDeclaration(reg);
                descriptors.add(attributes);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return descriptors;
    }

    public static class Descriptor {
        private String text;
        private String value;
        private String[] valueComponents;
        private Map<String, String> attributes;
        private Map<String, String> directives;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String[] getValueComponents() {
            return this.valueComponents;
        }

        public void setValueComponents(String[] valueComponents) {
            this.valueComponents = valueComponents;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public String toString() {
            return this.text;
        }

        static /* synthetic */ String[] access$202(Descriptor x0, String[] x1) {
            x0.valueComponents = x1;
            return x1;
        }
    }
}

