/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDeclarationParser;
import org.apache.tuscany.sca.extensibility.ServiceDiscoverer;

public class ContextClassLoaderServiceDiscoverer
implements ServiceDiscoverer {
    private static final Logger logger = Logger.getLogger(ContextClassLoaderServiceDiscoverer.class.getName());
    private WeakReference<ClassLoader> classLoaderReference;

    public ContextClassLoaderServiceDiscoverer() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.classLoaderReference = new WeakReference<ClassLoader>(classLoader);
    }

    public ContextClassLoaderServiceDiscoverer(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.classLoaderReference = new WeakReference<ClassLoader>(classLoader);
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Collection<URL> getResources(final String name) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<URL>>(){

                @Override
                public Collection<URL> run() throws IOException {
                    ArrayList<URL> urls = Collections.list(((ClassLoader)ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get()).getResources(name));
                    return new HashSet<URL>(urls);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    @Override
    public ServiceDeclaration getServiceDeclaration(String name) throws IOException {
        Collection<ServiceDeclaration> declarations = this.getServiceDeclarations(name);
        if (declarations.isEmpty()) {
            return null;
        }
        return declarations.iterator().next();
    }

    @Override
    public Collection<ServiceDeclaration> getServiceDeclarations(String serviceName) {
        HashSet<ServiceDeclaration> descriptors = new HashSet<ServiceDeclaration>();
        boolean isPropertyFile = "javax.xml.xpath.XPathFactory".equals(serviceName);
        String name = serviceName;
        name = serviceName.startsWith("/") ? serviceName.substring(1) : "META-INF/services/" + serviceName;
        boolean debug = logger.isLoggable(Level.FINE);
        try {
            for (URL url : this.getResources(name)) {
                if (debug) {
                    logger.fine("Reading service provider file: " + url.toExternalForm());
                }
                for (Map<String, String> attributes : ServiceDeclarationParser.load(url, isPropertyFile)) {
                    String className = attributes.get("class");
                    ServiceDeclarationImpl descriptor = new ServiceDeclarationImpl(url, className, attributes);
                    descriptors.add(descriptor);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return descriptors;
    }

    public class ServiceDeclarationImpl
    implements ServiceDeclaration {
        private URL url;
        private String className;
        private Class<?> javaClass;
        private Map<String, String> attributes;

        public ServiceDeclarationImpl(URL url, String className, Map<String, String> attributes) {
            this.url = url;
            this.className = className;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public URL getLocation() {
            return this.url;
        }

        @Override
        public Class<?> loadClass() throws ClassNotFoundException {
            if (this.className == null) {
                return null;
            }
            if (this.javaClass == null) {
                this.javaClass = this.loadClass(this.className);
            }
            return this.javaClass;
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            return Class.forName(className, false, (ClassLoader)ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Location: ").append(this.url);
            sb.append(" ClassLoader: ").append(ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get());
            sb.append(" Attributes: ").append(this.attributes);
            return sb.toString();
        }

        @Override
        public URL getResource(final String name) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return ((ClassLoader)ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get()).getResource(name);
                }
            });
        }

        @Override
        public boolean isAssignableTo(Class<?> serviceType) {
            try {
                this.loadClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this.javaClass != null && serviceType.isAssignableFrom(this.javaClass);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return Collections.enumeration(ContextClassLoaderServiceDiscoverer.this.getResources(name));
        }
    }
}

