/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.util;

import java.util.List;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;

public class OperationDataBindingHelper {
    private static boolean isTransformationRequired(DataType source, DataType target) {
        String targetDataBinding;
        if (source == null || target == null) {
            return false;
        }
        if (source == target) {
            return false;
        }
        String sourceDataBinding = source.getDataBinding();
        if (sourceDataBinding == (targetDataBinding = target.getDataBinding())) {
            return false;
        }
        if (sourceDataBinding == null || targetDataBinding == null) {
            return false;
        }
        return !sourceDataBinding.equals(targetDataBinding);
    }

    public static boolean isTransformationRequired(Operation source, Operation target) {
        if (source == target) {
            return false;
        }
        if (source.isInputWrapperStyle() != target.isInputWrapperStyle()) {
            return true;
        }
        if (source.isOutputWrapperStyle() != target.isOutputWrapperStyle()) {
            return true;
        }
        List<DataType> sourceOutputType = source.getOutputType().getLogical();
        List<DataType> targetOutputType = target.getOutputType().getLogical();
        int outputSize = sourceOutputType.size();
        if (outputSize != targetOutputType.size()) {
            return true;
        }
        for (int i = 0; i < outputSize; ++i) {
            if (!OperationDataBindingHelper.isTransformationRequired(sourceOutputType.get(i), targetOutputType.get(i))) continue;
            return true;
        }
        List<DataType> sourceInputType = source.getInputType().getLogical();
        List<DataType> targetInputType = target.getInputType().getLogical();
        int size = sourceInputType.size();
        if (size != targetInputType.size()) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (!OperationDataBindingHelper.isTransformationRequired(sourceInputType.get(i), targetInputType.get(i))) continue;
            return true;
        }
        return false;
    }
}

