/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class XSDDataTypeConverter {
    private static final Logger logger = Logger.getLogger(XSDDataTypeConverter.class.getName(), "org.apache.tuscany.sca.databinding.databinding-validation-messages");
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final int MAX_UNSIGNED_SHORT = 65535;

    public String parseAnySimpleType(String value) {
        return value;
    }

    public byte[] parseBase64Binary(String value) {
        return Base64Binary.decode(value);
    }

    public boolean parseBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public byte parseByte(String value) {
        return Byte.parseByte(value);
    }

    public Calendar parseDate(String value) {
        XSDDateFormat format = new XSDDateFormat();
        ParsePosition pos = new ParsePosition(0);
        Calendar cal = (Calendar)format.parseObject(value, pos);
        if (cal == null) {
            String message = logger.getResourceBundle().getString("BadDate");
            message = message.replace("{0}", value);
            message = message.replace("{1}", value.substring(pos.getErrorIndex()));
            throw new IllegalArgumentException(message);
        }
        return cal;
    }

    public Calendar parseDateTime(String value) {
        XSDDateTimeFormat format = new XSDDateTimeFormat();
        ParsePosition pos = new ParsePosition(0);
        Calendar cal = (Calendar)format.parseObject(value, pos);
        if (cal == null) {
            String message = logger.getResourceBundle().getString("BadDateTime");
            message = message.replace("{0}", value);
            message = message.replace("{1}", value.substring(pos.getErrorIndex()));
            throw new IllegalArgumentException(message);
        }
        return cal;
    }

    public BigDecimal parseDecimal(String value) {
        return new BigDecimal(value);
    }

    public double parseDouble(String value) {
        if ("INF".equals(value)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(value)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(value)) {
            return Double.NaN;
        }
        return Double.parseDouble(value);
    }

    public Duration parseDuration(String pDuration) {
        try {
            return DatatypeFactory.newInstance().newDuration(pDuration);
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public float parseFloat(String value) {
        if ("INF".equals(value)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-INF".equals(value)) {
            return Float.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(value)) {
            return Float.NaN;
        }
        return Float.parseFloat(value);
    }

    public byte[] parseHexBinary(String value) {
        return HexBinary.decode(value);
    }

    public int parseInt(String value) {
        return Integer.parseInt(value);
    }

    public BigInteger parseInteger(String value) {
        return new BigInteger(value);
    }

    public long parseLong(String value) {
        return Long.parseLong(value);
    }

    public QName parseQName(String value, NamespaceContext context) {
        String uri;
        String localName;
        int offset = value.indexOf(58);
        switch (offset) {
            case -1: {
                localName = value;
                uri = context.getNamespaceURI("");
                if (uri != null) break;
                throw new IllegalArgumentException(logger.getResourceBundle().getString("DefaultPrefixNotBound"));
            }
            case 0: {
                throw new IllegalArgumentException(logger.getResourceBundle().getString("NoColonForPrefix") + " " + value);
            }
            default: {
                String prefix = value.substring(0, offset);
                localName = value.substring(offset + 1);
                uri = context.getNamespaceURI(prefix);
                if (uri != null) break;
                String message = logger.getResourceBundle().getString("PrefixNotBound");
                message = message.replace("{0}", prefix);
                throw new IllegalArgumentException(message);
            }
        }
        return new QName(uri, localName);
    }

    public short parseShort(String value) {
        return Short.parseShort(value);
    }

    public String parseString(String value) {
        return value;
    }

    public Calendar parseTime(String value) {
        XSDTimeFormat format = new XSDTimeFormat();
        ParsePosition pos = new ParsePosition(0);
        Calendar cal = (Calendar)format.parseObject(value, pos);
        if (cal == null) {
            String message = logger.getResourceBundle().getString("BadTime");
            message = message.replace("{0}", value);
            message = message.replace("{1}", value.substring(pos.getErrorIndex()));
            throw new IllegalArgumentException(message);
        }
        return cal;
    }

    public long parseUnsignedInt(String value) {
        long l = Long.parseLong(value);
        if (l < 0L) {
            String message = logger.getResourceBundle().getString("BadUnsignedIntNegative");
            message = message.replace("{0}", value);
            throw new IllegalArgumentException(message);
        }
        if (l > 0xFFFFFFFFL) {
            String message = logger.getResourceBundle().getString("BadUnsignedIntMax");
            message = message.replace("{0}", value);
            message = message.replace("{1}", String.valueOf(0xFFFFFFFFL));
            throw new IllegalArgumentException(message);
        }
        return l;
    }

    public int parseUnsignedShort(String value) {
        int i = Integer.parseInt(value);
        if (i < 0) {
            String message = logger.getResourceBundle().getString("BadUnsignedShortNegative");
            message = message.replace("{0}", value);
            throw new IllegalArgumentException(message);
        }
        if (i > 65535) {
            String message = logger.getResourceBundle().getString("BadUnsignedShortMax");
            message = message.replace("{0}", value);
            message = message.replace("{1}", String.valueOf(65535));
            throw new IllegalArgumentException(message);
        }
        return i;
    }

    public String printAnySimpleType(String value) {
        return value;
    }

    public String printBase64Binary(byte[] value) {
        return Base64Binary.encode(value);
    }

    public String printBoolean(boolean value) {
        return (value ? Boolean.TRUE : Boolean.FALSE).toString();
    }

    public String printByte(byte value) {
        return Byte.toString(value);
    }

    public String printDate(Calendar value) {
        return new XSDDateFormat().format(value);
    }

    public String printDateTime(Calendar value) {
        return new XSDDateTimeFormat().format(value);
    }

    public String printDecimal(BigDecimal value) {
        return value.toString();
    }

    public String printDouble(double value) {
        return Double.toString(value);
    }

    public String printDuration(Duration pDuration) {
        return pDuration.toString();
    }

    public String printFloat(float value) {
        return Float.toString(value);
    }

    public String printHexBinary(byte[] value) {
        return HexBinary.encode(value);
    }

    public String printInt(int value) {
        return Integer.toString(value);
    }

    public String printInteger(BigInteger value) {
        return value.toString();
    }

    public String printLong(long value) {
        return Long.toString(value);
    }

    public String printQName(QName value, NamespaceContext context) {
        String prefix = context.getPrefix(value.getNamespaceURI());
        if (prefix == null) {
            String message = logger.getResourceBundle().getString("NamespaceNotBound");
            message = message.replace("{0}", value.getNamespaceURI());
            throw new IllegalArgumentException(message);
        }
        if ("".equals(prefix)) {
            return value.getLocalPart();
        }
        return prefix + ":" + value.getLocalPart();
    }

    public String printShort(short value) {
        return Short.toString(value);
    }

    public String printString(String value) {
        return value;
    }

    public String printTime(Calendar value) {
        return new XSDTimeFormat().format(value);
    }

    public String printUnsignedInt(long value) {
        return Long.toString(value);
    }

    public String printUnsignedShort(int value) {
        return Integer.toString(value);
    }

    public static class XSDTimeFormat
    extends XSDDateTimeFormat {
        private static final long serialVersionUID = 1346506860724640517L;

        public XSDTimeFormat() {
            super(false, true);
        }
    }

    public static class XSDDateTimeFormat
    extends Format {
        private static final long serialVersionUID = -1148332471737068969L;
        final boolean parseDate;
        final boolean parseTime;

        public XSDDateTimeFormat() {
            this(true, true);
        }

        XSDDateTimeFormat(boolean pParseDate, boolean pParseTime) {
            this.parseDate = pParseDate;
            this.parseTime = pParseTime;
        }

        private void append(StringBuffer pBuffer, int pNum, int pMinLen) {
            String s = Integer.toString(pNum);
            for (int i = s.length(); i < pMinLen; ++i) {
                pBuffer.append('0');
            }
            pBuffer.append(s);
        }

        @Override
        public StringBuffer format(Object pCalendar, StringBuffer pBuffer, FieldPosition pPos) {
            assert (pCalendar != null) : "The Calendar argument must not be null.";
            assert (pBuffer != null) : "The StringBuffer argument must not be null.";
            assert (pPos != null) : "The FieldPosition argument must not be null.";
            Calendar cal = (Calendar)pCalendar;
            if (this.parseDate) {
                int year = cal.get(1);
                if (year < 0) {
                    pBuffer.append('-');
                    year = -year;
                }
                this.append(pBuffer, year, 4);
                pBuffer.append('-');
                this.append(pBuffer, cal.get(2) + 1, 2);
                pBuffer.append('-');
                this.append(pBuffer, cal.get(5), 2);
                if (this.parseTime) {
                    pBuffer.append('T');
                }
            }
            if (this.parseTime) {
                this.append(pBuffer, cal.get(11), 2);
                pBuffer.append(':');
                this.append(pBuffer, cal.get(12), 2);
                pBuffer.append(':');
                this.append(pBuffer, cal.get(13), 2);
                int millis = cal.get(14);
                if (millis > 0) {
                    pBuffer.append('.');
                    this.append(pBuffer, millis, 3);
                }
            }
            TimeZone tz = cal.getTimeZone();
            int offset = cal.get(15);
            if (tz.inDaylightTime(cal.getTime())) {
                offset += cal.get(16);
            }
            if (offset == 0) {
                pBuffer.append('Z');
            } else {
                if (offset < 0) {
                    pBuffer.append('-');
                    offset = -offset;
                } else {
                    pBuffer.append('+');
                }
                int minutes = offset / 60000;
                int hours = minutes / 60;
                this.append(pBuffer, hours, 2);
                pBuffer.append(':');
                this.append(pBuffer, minutes -= hours * 60, 2);
            }
            return pBuffer;
        }

        private int parseInt(String pString, int offset, StringBuffer pDigits) {
            char c;
            int pOffset;
            int length = pString.length();
            pDigits.setLength(0);
            for (pOffset = offset; pOffset < length && Character.isDigit(c = pString.charAt(pOffset)); ++pOffset) {
                pDigits.append(c);
            }
            return pOffset;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Object parseObject(String pString, ParsePosition pParsePosition) {
            int millis;
            int second;
            int minute;
            int hour;
            int mday;
            int month;
            int year;
            StringBuffer digits;
            boolean isMinus;
            int length;
            int offset;
            block21: {
                block29: {
                    block34: {
                        block35: {
                            block33: {
                                block31: {
                                    block32: {
                                        block30: {
                                            block20: {
                                                block22: {
                                                    block27: {
                                                        block28: {
                                                            block26: {
                                                                block24: {
                                                                    block25: {
                                                                        block23: {
                                                                            assert (pString != null) : "The String argument must not be null.";
                                                                            assert (pParsePosition != null) : "The ParsePosition argument must not be null.";
                                                                            offset = pParsePosition.getIndex();
                                                                            length = pString.length();
                                                                            isMinus = false;
                                                                            digits = new StringBuffer();
                                                                            year = 0;
                                                                            month = 0;
                                                                            mday = 0;
                                                                            if (!this.parseDate) break block22;
                                                                            if (offset < length) {
                                                                                char c = pString.charAt(offset);
                                                                                if (c == '+') {
                                                                                    ++offset;
                                                                                } else if (c == '-') {
                                                                                    ++offset;
                                                                                    isMinus = true;
                                                                                }
                                                                            }
                                                                            offset = this.parseInt(pString, offset, digits);
                                                                            if (digits.length() < 4) {
                                                                                pParsePosition.setErrorIndex(offset);
                                                                                return null;
                                                                            }
                                                                            year = Integer.parseInt(digits.toString());
                                                                            if (offset >= length || pString.charAt(offset) != '-') break block23;
                                                                            ++offset;
                                                                            offset = this.parseInt(pString, offset, digits);
                                                                            if (digits.length() == 2) break block24;
                                                                            break block25;
                                                                        }
                                                                        pParsePosition.setErrorIndex(offset);
                                                                        return null;
                                                                    }
                                                                    pParsePosition.setErrorIndex(offset);
                                                                    return null;
                                                                }
                                                                month = Integer.parseInt(digits.toString());
                                                                if (offset >= length || pString.charAt(offset) != '-') break block26;
                                                                ++offset;
                                                                offset = this.parseInt(pString, offset, digits);
                                                                if (digits.length() == 2) break block27;
                                                                break block28;
                                                            }
                                                            pParsePosition.setErrorIndex(offset);
                                                            return null;
                                                        }
                                                        pParsePosition.setErrorIndex(offset);
                                                        return null;
                                                    }
                                                    mday = Integer.parseInt(digits.toString());
                                                    if (this.parseTime) {
                                                        if (offset < length && pString.charAt(offset) == 'T') {
                                                            ++offset;
                                                            break block20;
                                                        } else {
                                                            pParsePosition.setErrorIndex(offset);
                                                            return null;
                                                        }
                                                    }
                                                    break block20;
                                                }
                                                mday = 0;
                                                month = 0;
                                                year = 0;
                                            }
                                            hour = 0;
                                            minute = 0;
                                            second = 0;
                                            millis = 0;
                                            if (!this.parseTime) break block29;
                                            offset = this.parseInt(pString, offset, digits);
                                            if (digits.length() != 2) {
                                                pParsePosition.setErrorIndex(offset);
                                                return null;
                                            }
                                            hour = Integer.parseInt(digits.toString());
                                            if (offset >= length || pString.charAt(offset) != ':') break block30;
                                            ++offset;
                                            offset = this.parseInt(pString, offset, digits);
                                            if (digits.length() == 2) break block31;
                                            break block32;
                                        }
                                        pParsePosition.setErrorIndex(offset);
                                        return null;
                                    }
                                    pParsePosition.setErrorIndex(offset);
                                    return null;
                                }
                                minute = Integer.parseInt(digits.toString());
                                if (offset >= length || pString.charAt(offset) != ':') break block33;
                                ++offset;
                                offset = this.parseInt(pString, offset, digits);
                                if (digits.length() == 2) break block34;
                                break block35;
                            }
                            pParsePosition.setErrorIndex(offset);
                            return null;
                        }
                        pParsePosition.setErrorIndex(offset);
                        return null;
                    }
                    second = Integer.parseInt(digits.toString());
                    if (offset < length && pString.charAt(offset) == '.') {
                        ++offset;
                        offset = this.parseInt(pString, offset, digits);
                        millis = digits.length() > 0 ? Integer.parseInt(digits.toString()) : 0;
                        break block21;
                    } else {
                        millis = 0;
                    }
                    break block21;
                }
                millis = 0;
                second = 0;
                minute = 0;
                hour = 0;
            }
            digits.setLength(0);
            digits.append("GMT");
            if (offset < length) {
                char c = pString.charAt(offset);
                if (c == 'Z') {
                    ++offset;
                } else if (c == '+' || c == '-') {
                    digits.append(c);
                    ++offset;
                    for (int i = 0; i < 5; ++offset, ++i) {
                        if (offset >= length) {
                            pParsePosition.setErrorIndex(offset);
                            return null;
                        }
                        c = pString.charAt(offset);
                        if (i != 2 && Character.isDigit(c) || i == 2 && c == ':') {
                            digits.append(c);
                            continue;
                        }
                        pParsePosition.setErrorIndex(offset);
                        return null;
                    }
                }
            }
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(digits.toString()));
            cal.set(isMinus ? -year : year, this.parseDate ? month - 1 : month, mday, hour, minute, second);
            cal.set(14, millis);
            pParsePosition.setIndex(offset);
            return cal;
        }
    }

    public class XSDDateFormat
    extends XSDDateTimeFormat {
        private static final long serialVersionUID = -1629412916827246627L;

        public XSDDateFormat() {
            super(true, false);
        }
    }

    public static final class HexBinary {
        private HexBinary() {
        }

        public static byte[] decode(String pValue) {
            if (pValue.length() % 2 != 0) {
                throw new IllegalArgumentException(logger.getResourceBundle().getString("HexBinaryUnevenLength"));
            }
            byte[] result = new byte[pValue.length() / 2];
            int j = 0;
            int i = 0;
            while (i < pValue.length()) {
                byte b;
                char c = pValue.charAt(i++);
                char d = pValue.charAt(i++);
                if (c >= '0' && c <= '9') {
                    b = (byte)(c - 48 << 4);
                } else if (c >= 'A' && c <= 'F') {
                    b = (byte)(c - 65 + 10 << 4);
                } else if (c >= 'a' && c <= 'f') {
                    b = (byte)(c - 97 + 10 << 4);
                } else {
                    throw new IllegalArgumentException(logger.getResourceBundle().getString("InvalidHexDigit") + " " + c);
                }
                if (d >= '0' && d <= '9') {
                    b = (byte)(b + (byte)(d - 48));
                } else if (d >= 'A' && d <= 'F') {
                    b = (byte)(b + (byte)(d - 65 + 10));
                } else if (d >= 'a' && d <= 'f') {
                    b = (byte)(b + (byte)(d - 97 + 10));
                } else {
                    throw new IllegalArgumentException(logger.getResourceBundle().getString("InvalidHexDigit") + " " + d);
                }
                result[j++] = b;
            }
            return result;
        }

        public static String encode(byte[] pHexBinary) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < pHexBinary.length; ++i) {
                byte b = pHexBinary[i];
                byte c = (byte)((b & 0xF0) >> 4);
                if (c <= 9) {
                    result.append((char)(48 + c));
                } else {
                    result.append((char)(65 + c - 10));
                }
                c = (byte)(b & 0xF);
                if (c <= 9) {
                    result.append((char)(48 + c));
                    continue;
                }
                result.append((char)(65 + c - 10));
            }
            return result.toString();
        }

        public static byte[] getClone(byte[] pHexBinary) {
            byte[] result = new byte[pHexBinary.length];
            System.arraycopy(pHexBinary, 0, result, 0, pHexBinary.length);
            return result;
        }
    }

    public static final class Base64Binary {
        private static final char[] S_BASE64CHAR;
        private static final char S_BASE64PAD = '=';
        private static final byte[] S_DECODETABLE;

        private Base64Binary() {
        }

        public static byte[] decode(char[] data, int off, int len) {
            char[] ibuf = new char[4];
            int ibufcount = 0;
            byte[] obuf = new byte[len / 4 * 3 + 3];
            int obufcount = 0;
            for (int i = off; i < off + len; ++i) {
                char ch = data[i];
                if (ch != '=' && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
                ibuf[ibufcount++] = ch;
                if (ibufcount != ibuf.length) continue;
                ibufcount = 0;
                obufcount += Base64Binary.decode0(ibuf, obuf, obufcount);
            }
            if (obufcount == obuf.length) {
                return obuf;
            }
            byte[] ret = new byte[obufcount];
            System.arraycopy(obuf, 0, ret, 0, obufcount);
            return ret;
        }

        public static void decode(char[] data, int off, int len, OutputStream ostream) throws IOException {
            char[] ibuf = new char[4];
            int ibufcount = 0;
            byte[] obuf = new byte[3];
            for (int i = off; i < off + len; ++i) {
                char ch = data[i];
                if (ch != '=' && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
                ibuf[ibufcount++] = ch;
                if (ibufcount != ibuf.length) continue;
                ibufcount = 0;
                int obufcount = Base64Binary.decode0(ibuf, obuf, 0);
                ostream.write(obuf, 0, obufcount);
            }
        }

        public static byte[] decode(String data) {
            char[] ibuf = new char[4];
            int ibufcount = 0;
            byte[] obuf = new byte[data.length() / 4 * 3 + 3];
            int obufcount = 0;
            for (int i = 0; i < data.length(); ++i) {
                char ch = data.charAt(i);
                if (ch != '=' && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
                ibuf[ibufcount++] = ch;
                if (ibufcount != ibuf.length) continue;
                ibufcount = 0;
                obufcount += Base64Binary.decode0(ibuf, obuf, obufcount);
            }
            if (obufcount == obuf.length) {
                return obuf;
            }
            byte[] ret = new byte[obufcount];
            System.arraycopy(obuf, 0, ret, 0, obufcount);
            return ret;
        }

        public static void decode(String data, OutputStream ostream) throws IOException {
            char[] ibuf = new char[4];
            int ibufcount = 0;
            byte[] obuf = new byte[3];
            for (int i = 0; i < data.length(); ++i) {
                char ch = data.charAt(i);
                if (ch != '=' && (ch >= S_DECODETABLE.length || S_DECODETABLE[ch] == 127)) continue;
                ibuf[ibufcount++] = ch;
                if (ibufcount != ibuf.length) continue;
                ibufcount = 0;
                int obufcount = Base64Binary.decode0(ibuf, obuf, 0);
                ostream.write(obuf, 0, obufcount);
            }
        }

        private static int decode0(char[] ibuf, byte[] obuf, int index) {
            int wp = index;
            int outlen = 3;
            if (ibuf[3] == '=') {
                outlen = 2;
            }
            if (ibuf[2] == '=') {
                outlen = 1;
            }
            byte b0 = S_DECODETABLE[ibuf[0]];
            byte b1 = S_DECODETABLE[ibuf[1]];
            byte b2 = S_DECODETABLE[ibuf[2]];
            byte b3 = S_DECODETABLE[ibuf[3]];
            switch (outlen) {
                case 1: {
                    obuf[wp] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                    return 1;
                }
                case 2: {
                    obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                    obuf[wp] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                    return 2;
                }
                case 3: {
                    obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                    obuf[wp++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                    obuf[wp] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
                    return 3;
                }
            }
            throw new IllegalArgumentException(logger.getResourceBundle().getString("NotBase64Encoded"));
        }

        public static String encode(byte[] data) {
            return Base64Binary.encode(data, 0, data.length);
        }

        public static String encode(byte[] data, int off, int len) {
            int i;
            int rest;
            if (len <= 0) {
                return "";
            }
            char[] out = new char[len / 3 * 4 + 4];
            int rindex = off;
            int windex = 0;
            for (rest = len - off; rest >= 3; rest -= 3) {
                i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
                out[windex++] = S_BASE64CHAR[i >> 18];
                out[windex++] = S_BASE64CHAR[i >> 12 & 0x3F];
                out[windex++] = S_BASE64CHAR[i >> 6 & 0x3F];
                out[windex++] = S_BASE64CHAR[i & 0x3F];
                rindex += 3;
            }
            if (rest == 1) {
                i = data[rindex] & 0xFF;
                out[windex++] = S_BASE64CHAR[i >> 2];
                out[windex++] = S_BASE64CHAR[i << 4 & 0x3F];
                out[windex++] = 61;
                out[windex++] = 61;
            } else if (rest == 2) {
                i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
                out[windex++] = S_BASE64CHAR[i >> 10];
                out[windex++] = S_BASE64CHAR[i >> 4 & 0x3F];
                out[windex++] = S_BASE64CHAR[i << 2 & 0x3F];
                out[windex++] = 61;
            }
            return new String(out, 0, windex);
        }

        public static void encode(byte[] data, int off, int len, OutputStream ostream) throws IOException {
            int i;
            int rest;
            if (len <= 0) {
                return;
            }
            byte[] out = new byte[4];
            int rindex = off;
            for (rest = len - off; rest >= 3; rest -= 3) {
                i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
                out[0] = (byte)S_BASE64CHAR[i >> 18];
                out[1] = (byte)S_BASE64CHAR[i >> 12 & 0x3F];
                out[2] = (byte)S_BASE64CHAR[i >> 6 & 0x3F];
                out[3] = (byte)S_BASE64CHAR[i & 0x3F];
                ostream.write(out, 0, 4);
                rindex += 3;
            }
            if (rest == 1) {
                i = data[rindex] & 0xFF;
                out[0] = (byte)S_BASE64CHAR[i >> 2];
                out[1] = (byte)S_BASE64CHAR[i << 4 & 0x3F];
                out[2] = 61;
                out[3] = 61;
                ostream.write(out, 0, 4);
            } else if (rest == 2) {
                i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
                out[0] = (byte)S_BASE64CHAR[i >> 10];
                out[1] = (byte)S_BASE64CHAR[i >> 4 & 0x3F];
                out[2] = (byte)S_BASE64CHAR[i << 2 & 0x3F];
                out[3] = 61;
                ostream.write(out, 0, 4);
            }
        }

        public static void encode(byte[] data, int off, int len, Writer writer) throws IOException {
            int i;
            int rest;
            if (len <= 0) {
                return;
            }
            char[] out = new char[4];
            int rindex = off;
            int output = 0;
            for (rest = len - off; rest >= 3; rest -= 3) {
                i = ((data[rindex] & 0xFF) << 16) + ((data[rindex + 1] & 0xFF) << 8) + (data[rindex + 2] & 0xFF);
                out[0] = S_BASE64CHAR[i >> 18];
                out[1] = S_BASE64CHAR[i >> 12 & 0x3F];
                out[2] = S_BASE64CHAR[i >> 6 & 0x3F];
                out[3] = S_BASE64CHAR[i & 0x3F];
                writer.write(out, 0, 4);
                rindex += 3;
                if ((output += 4) % 76 != 0) continue;
                writer.write("\n");
            }
            if (rest == 1) {
                i = data[rindex] & 0xFF;
                out[0] = S_BASE64CHAR[i >> 2];
                out[1] = S_BASE64CHAR[i << 4 & 0x3F];
                out[2] = 61;
                out[3] = 61;
                writer.write(out, 0, 4);
            } else if (rest == 2) {
                i = ((data[rindex] & 0xFF) << 8) + (data[rindex + 1] & 0xFF);
                out[0] = S_BASE64CHAR[i >> 10];
                out[1] = S_BASE64CHAR[i >> 4 & 0x3F];
                out[2] = S_BASE64CHAR[i << 2 & 0x3F];
                out[3] = 61;
                writer.write(out, 0, 4);
            }
        }

        static {
            int i;
            S_BASE64CHAR = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
            S_DECODETABLE = new byte[128];
            for (i = 0; i < S_DECODETABLE.length; ++i) {
                Base64Binary.S_DECODETABLE[i] = 127;
            }
            for (i = 0; i < S_BASE64CHAR.length; ++i) {
                Base64Binary.S_DECODETABLE[Base64Binary.S_BASE64CHAR[i]] = (byte)i;
            }
        }
    }
}

