/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.tuscany.sca.core.invocation.impl.PhaseManager;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InterceptorAsync;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncRequest;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;

public class InvocationChainImpl
implements InvocationChain {
    private Operation sourceOperation;
    private Operation targetOperation;
    private List<Node> nodes = new ArrayList<Node>();
    private final PhaseManager phaseManager;
    private boolean forReference;
    private boolean allowsPassByReference;
    private boolean isAsyncInvocation;

    public InvocationChainImpl(Operation sourceOperation, Operation targetOperation, boolean forReference, PhaseManager phaseManager, boolean isAsyncInvocation) {
        this.targetOperation = targetOperation;
        this.sourceOperation = sourceOperation;
        this.forReference = forReference;
        this.phaseManager = phaseManager;
        this.isAsyncInvocation = isAsyncInvocation;
    }

    @Override
    public Operation getTargetOperation() {
        return this.targetOperation;
    }

    @Override
    public void setTargetOperation(Operation operation) {
        this.targetOperation = operation;
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        PhasedInterceptor pi;
        if (interceptor instanceof PhasedInterceptor && (pi = (PhasedInterceptor)interceptor).getPhase() != null) {
            this.addInvoker(pi.getPhase(), pi);
            return;
        }
        String phase = this.forReference ? "component.reference" : "component.service";
        this.addInterceptor(phase, interceptor);
    }

    @Override
    public void addInvoker(Invoker invoker) {
        PhasedInterceptor pi;
        if (invoker instanceof PhasedInterceptor && (pi = (PhasedInterceptor)invoker).getPhase() != null) {
            this.addInvoker(pi.getPhase(), pi);
            return;
        }
        String phase = this.forReference ? "reference.binding" : "component.implementation";
        this.addInvoker(phase, invoker);
    }

    @Override
    public Invoker getHeadInvoker() {
        return this.nodes.isEmpty() ? null : this.nodes.get(0).getInvoker();
    }

    @Override
    public Invoker getTailInvoker() {
        int nodeCount = this.nodes.size();
        if (nodeCount > 0) {
            return this.nodes.get(nodeCount - 1).getInvoker();
        }
        return null;
    }

    @Override
    public Invoker getHeadInvoker(String phase) {
        int index = this.phaseManager.getAllPhases().indexOf(phase);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid phase name: " + phase);
        }
        for (Node node : this.nodes) {
            if (index > node.getPhaseIndex()) continue;
            return node.getInvoker();
        }
        return null;
    }

    @Override
    public Operation getSourceOperation() {
        return this.sourceOperation;
    }

    @Override
    public void setSourceOperation(Operation sourceOperation) {
        this.sourceOperation = sourceOperation;
    }

    @Override
    public void addInterceptor(String phase, Interceptor interceptor) {
        this.addInvoker(phase, interceptor);
    }

    private void addInvoker(String phase, Invoker invoker) {
        int index;
        if (!this.isAsyncInvocation || invoker instanceof InvokerAsyncRequest || !(invoker instanceof InvokerAsyncResponse)) {
            // empty if block
        }
        if ((index = this.phaseManager.getAllPhases().indexOf(phase)) == -1) {
            throw new IllegalArgumentException("Invalid phase name: " + phase);
        }
        Node node = new Node(index, invoker);
        ListIterator<Node> li = this.nodes.listIterator();
        Node before = null;
        Node after = null;
        boolean found = false;
        while (li.hasNext()) {
            before = after;
            after = li.next();
            if (after.getPhaseIndex() <= index) continue;
            li.previous();
            li.add(node);
            found = true;
            break;
        }
        if (!found) {
            this.nodes.add(node);
            before = after;
            after = null;
        }
        if (before != null && before.getInvoker() instanceof Interceptor) {
            ((Interceptor)before.getInvoker()).setNext(invoker);
            if (invoker instanceof InterceptorAsync && before.getInvoker() instanceof InvokerAsyncResponse) {
                ((InterceptorAsync)invoker).setPrevious((InvokerAsyncResponse)((Object)before.getInvoker()));
            }
        }
        if (after != null && invoker instanceof Interceptor) {
            ((Interceptor)invoker).setNext(after.getInvoker());
            if (after.getInvoker() instanceof InterceptorAsync && invoker instanceof InvokerAsyncResponse) {
                ((InterceptorAsync)after.getInvoker()).setPrevious((InvokerAsyncResponse)((Object)invoker));
            }
        }
    }

    @Override
    public boolean allowsPassByReference() {
        if (this.allowsPassByReference) {
            return true;
        }
        boolean allowsPBR = false;
        for (Node i : this.nodes) {
            if (!(i.getInvoker() instanceof DataExchangeSemantics) || !((DataExchangeSemantics)((Object)i.getInvoker())).allowsPassByReference()) continue;
            allowsPBR = true;
            break;
        }
        return allowsPBR;
    }

    @Override
    public void setAllowsPassByReference(boolean allowsPBR) {
        this.allowsPassByReference = allowsPBR;
    }

    @Override
    public boolean isAsyncInvocation() {
        return this.isAsyncInvocation;
    }

    @Override
    public void addHeadInterceptor(Interceptor interceptor) {
        PhasedInterceptor pi;
        String phase;
        String string = phase = this.forReference ? "component.reference" : "service.binding";
        if (interceptor instanceof PhasedInterceptor && (pi = (PhasedInterceptor)interceptor).getPhase() != null) {
            phase = pi.getPhase();
        }
        this.addHeadInterceptor(phase, interceptor);
    }

    @Override
    public void addHeadInterceptor(String phase, Interceptor interceptor) {
        Interceptor invoker = interceptor;
        int index = this.phaseManager.getAllPhases().indexOf(phase);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid phase name: " + phase);
        }
        Node node = new Node(index, invoker);
        ListIterator<Node> li = this.nodes.listIterator();
        Node before = null;
        Node after = null;
        boolean found = false;
        while (li.hasNext()) {
            before = after;
            after = li.next();
            if (after.getPhaseIndex() < index) continue;
            li.previous();
            li.add(node);
            found = true;
            break;
        }
        if (!found) {
            this.nodes.add(node);
            before = after;
            after = null;
        }
        if (before != null && before.getInvoker() instanceof Interceptor) {
            ((Interceptor)before.getInvoker()).setNext(invoker);
            if (invoker instanceof InterceptorAsync && before.getInvoker() instanceof InvokerAsyncResponse) {
                ((InterceptorAsync)invoker).setPrevious((InvokerAsyncResponse)((Object)before.getInvoker()));
            }
        }
        if (after != null && invoker instanceof Interceptor) {
            invoker.setNext(after.getInvoker());
            if (after.getInvoker() instanceof InterceptorAsync && invoker instanceof InvokerAsyncResponse) {
                ((InterceptorAsync)after.getInvoker()).setPrevious((InvokerAsyncResponse)((Object)invoker));
            }
        }
    }

    private static class Node {
        private int phaseIndex;
        private Invoker invoker;

        public Node(int phaseIndex, Invoker invoker) {
            this.phaseIndex = phaseIndex;
            this.invoker = invoker;
        }

        public int getPhaseIndex() {
            return this.phaseIndex;
        }

        public Invoker getInvoker() {
            return this.invoker;
        }

        public String toString() {
            return "(" + this.phaseIndex + ")" + this.invoker;
        }
    }
}

