/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.util.Collection;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.interfacedef.DataType;

public class Collection2CollectionTransformer
extends BaseTransformer<Collection, Collection>
implements PullTransformer<Collection, Collection> {
    private static final String JAVA_COLLECTION = "java:collection";
    protected Mediator mediator;

    public Collection2CollectionTransformer(ExtensionPointRegistry registry) {
        this.mediator = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(Mediator.class);
    }

    @Override
    public String getSourceDataBinding() {
        return JAVA_COLLECTION;
    }

    @Override
    public String getTargetDataBinding() {
        return JAVA_COLLECTION;
    }

    @Override
    protected Class<Collection> getSourceType() {
        return Collection.class;
    }

    @Override
    protected Class<Collection> getTargetType() {
        return Collection.class;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public Collection transform(Collection sourceCollection, TransformationContext context) {
        try {
            if (sourceCollection == null) {
                return null;
            }
            DataType sourceType = context.getSourceDataType();
            DataType targetType = context.getTargetDataType();
            Collection targetCollection = this.createCollection(targetType.getPhysical());
            for (Object sourceItem : sourceCollection) {
                Object targetItem = this.mediator.mediate(sourceItem, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
                targetCollection.add(targetItem);
            }
            return targetCollection;
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    private Collection createCollection(Class<?> collectionClass) throws Exception {
        return (Collection)collectionClass.newInstance();
    }
}

