/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.core.ModuleActivatorExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceHelper;

public class DefaultModuleActivatorExtensionPoint
implements ModuleActivatorExtensionPoint {
    private static final Logger logger = Logger.getLogger(DefaultModuleActivatorExtensionPoint.class.getName());
    private List<ModuleActivator> activators = new ArrayList<ModuleActivator>();
    private boolean loadedActivators;
    private boolean started;
    private ExtensionPointRegistry registry;

    public DefaultModuleActivatorExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addModuleActivator(ModuleActivator activator) {
        this.activators.add(activator);
    }

    @Override
    public List<ModuleActivator> getModuleActivators() {
        this.loadModuleActivators();
        return this.activators;
    }

    @Override
    public void removeModuleActivator(ModuleActivator activator) {
        if (this.activators.remove(activator)) {
            activator.stop();
        }
    }

    private synchronized void loadModuleActivators() {
        Collection<ServiceDeclaration> activatorDeclarations;
        if (this.loadedActivators) {
            return;
        }
        try {
            activatorDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations(ModuleActivator.class.getName(), true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration activatorDeclaration : activatorDeclarations) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading " + activatorDeclaration.getClassName());
            }
            ModuleActivator activator = null;
            try {
                Class<?> activatorClass = activatorDeclaration.loadClass();
                try {
                    activator = (ModuleActivator)ServiceHelper.newInstance(activatorClass, ExtensionPointRegistry.class, (Object)this.registry);
                }
                catch (NoSuchMethodException e) {
                    try {
                        activator = (ModuleActivator)ServiceHelper.newInstance(activatorClass, new Class[]{ExtensionPointRegistry.class, Map.class}, this.registry, activatorDeclaration.getAttributes());
                    }
                    catch (NoSuchMethodException e1) {
                        activator = (ModuleActivator)ServiceHelper.newInstance(activatorClass);
                    }
                }
            }
            catch (Throwable e) {
                String optional = activatorDeclaration.getAttributes().get("optional");
                if ("true".equalsIgnoreCase(optional)) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                throw new IllegalArgumentException(e);
            }
            this.addModuleActivator(activator);
        }
        this.loadedActivators = true;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.getModuleActivators();
        for (ModuleActivator activator : this.activators) {
            try {
                activator.start();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        for (int i = this.activators.size() - 1; i >= 0; --i) {
            try {
                this.activators.get(i).stop();
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.started = false;
    }
}

