/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resolver;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class DefaultModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<Object, Object> map = new HashMap<Object, Object>();

    public DefaultModelResolver() {
    }

    public DefaultModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        Object resolved = this.map.get(unresolved);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        if (this.contribution != null) {
            for (Import _import : this.contribution.getImports()) {
                if (!(_import instanceof DefaultImport) || (resolved = _import.getModelResolver().resolveModel(modelClass, unresolved, context)) == unresolved) continue;
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }

    @Override
    public void addModel(Object resolved, ProcessorContext context) {
        this.map.put(resolved, resolved);
    }

    @Override
    public Object removeModel(Object resolved, ProcessorContext context) {
        return this.map.remove(resolved);
    }

    public Map<Object, Object> getModels() {
        return this.map;
    }
}

