/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.common.java.reflection.JavaIntrospectionHelper;
import org.apache.tuscany.sca.contribution.processor.ArtifactProcessor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;

abstract class DefaultArtifactProcessorExtensionPoint<P extends ArtifactProcessor<?>> {
    protected final Map<Object, P> processorsByArtifactType = new HashMap<Object, P>();
    protected final Map<Class<?>, P> processorsByModelType = new HashMap();
    protected ExtensionPointRegistry registry;
    private JavaIntrospectionHelper introspectionHelper;

    DefaultArtifactProcessorExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
        this.introspectionHelper = JavaIntrospectionHelper.getInstance(registry);
    }

    public P getProcessor(Object artifactType) {
        return (P)((ArtifactProcessor)this.processorsByArtifactType.get(artifactType));
    }

    public <T> P getProcessor(Class<T> modelType) {
        ArtifactProcessor processor = (ArtifactProcessor)this.processorsByModelType.get(modelType);
        if (processor != null) {
            return (P)processor;
        }
        List<Class<?>> classes = this.introspectionHelper.getAllInterfaces(modelType);
        for (Class<?> c : classes) {
            processor = (ArtifactProcessor)this.processorsByModelType.get(c);
            if (processor == null) continue;
            return (P)processor;
        }
        return null;
    }
}

