/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.java.JavaImportExportFactory;
import org.apache.tuscany.sca.contribution.java.impl.JavaExportModelResolver;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class JavaExportProcessor
implements StAXArtifactProcessor<JavaExport> {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final QName EXPORT_JAVA = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "export.java");
    private static final String PACKAGE = "package";
    private final JavaImportExportFactory factory;

    public JavaExportProcessor(FactoryExtensionPoint modelFactories) {
        this.factory = modelFactories.getFactory(JavaImportExportFactory.class);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-java-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return EXPORT_JAVA;
    }

    @Override
    public Class<JavaExport> getModelType() {
        return JavaExport.class;
    }

    @Override
    public JavaExport read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        JavaExport javaExport = this.factory.createJavaExport();
        QName element = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        element = reader.getName();
                        if (!EXPORT_JAVA.equals(element)) break;
                        String packageName = reader.getAttributeValue(null, PACKAGE);
                        if (packageName == null) {
                            this.error(context.getMonitor(), "AttributePackageMissing", reader, new Object[0]);
                            break;
                        }
                        javaExport.setPackage(packageName);
                        break;
                    }
                    case 2: {
                        if (!EXPORT_JAVA.equals(reader.getName())) break;
                        return javaExport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(context.getMonitor(), "XMLStreamException", reader, ex);
        }
        return javaExport;
    }

    @Override
    public void write(JavaExport javaExport, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(EXPORT_JAVA.getNamespaceURI(), EXPORT_JAVA.getLocalPart());
        if (javaExport.getPackage() != null) {
            writer.writeAttribute(PACKAGE, javaExport.getPackage());
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(JavaExport javaExport, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (javaExport.getPackage() != null) {
            javaExport.setModelResolver(new JavaExportModelResolver(javaExport, resolver));
        }
    }
}

