/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.java.reflection;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.oasisopen.sca.ServiceReference;

public final class JavaIntrospectionHelper {
    private static final Logger logger = Logger.getLogger(JavaIntrospectionHelper.class.getName());
    private static final Class<?>[] EMPTY_CLASS_ARRY = new Class[0];
    private ExtensionPointRegistry registry;
    private static final Map<Class<?>, String> signatures = new HashMap();

    public JavaIntrospectionHelper(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    public static JavaIntrospectionHelper getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        return utilities.getUtility(JavaIntrospectionHelper.class);
    }

    private static boolean matches(int modifiers, int include, int exclude) {
        if (include != -1 && (modifiers & include) == 0) {
            return false;
        }
        return exclude == -1 || (modifiers & exclude) == 0;
    }

    private static Set<Field> getAllFields(Class<?> clazz, Set<Field> fields, int include, int exclude) {
        Field[] declaredFields;
        if (clazz == null || clazz.isArray() || Object.class.equals(clazz)) {
            return fields;
        }
        fields = JavaIntrospectionHelper.getAllFields(clazz.getSuperclass(), fields, include, exclude);
        for (final Field field : declaredFields = clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!JavaIntrospectionHelper.matches(modifiers, include, exclude)) continue;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            fields.add(field);
        }
        return fields;
    }

    public Set<Field> getAllNonStaticOrFinalFields(Class<?> cls) {
        HashSet<Field> fields = new HashSet<Field>();
        return JavaIntrospectionHelper.getAllFields(cls, fields, -1, 24);
    }

    public Set<Method> getAllNonStaticMethods(Class<?> cls) {
        HashSet<Method> methods = new HashSet<Method>();
        return JavaIntrospectionHelper.getAllUniqueMethods(cls, methods, -1, 8);
    }

    private static Set<Method> getAllUniqueMethods(Class<?> pClass, Set<Method> methods, int include, int exclude) {
        Method[] declaredMethods;
        if (pClass == null || pClass.isArray() || Object.class.equals(pClass)) {
            return methods;
        }
        for (final Method declaredMethod : declaredMethods = pClass.getDeclaredMethods()) {
            int modifiers = declaredMethod.getModifiers();
            if (!JavaIntrospectionHelper.matches(modifiers, include, exclude)) continue;
            if (methods.size() == 0) {
                methods.add(declaredMethod);
                continue;
            }
            ArrayList<Method> temp = new ArrayList<Method>();
            boolean matched = false;
            for (Method method : methods) {
                if (!JavaIntrospectionHelper.exactMethodMatch(declaredMethod, method)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        declaredMethod.setAccessible(true);
                        return null;
                    }
                });
                temp.add(declaredMethod);
            }
            methods.addAll(temp);
            temp.clear();
        }
        methods = JavaIntrospectionHelper.getAllUniqueMethods(pClass.getSuperclass(), methods, include, exclude);
        return methods;
    }

    public static Field findClosestMatchingField(String name, Class type, Set<Field> fields) {
        Field candidate = null;
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            if (field.getType().equals(type)) {
                return field;
            }
            if (!field.getType().isAssignableFrom(type) && (!field.getType().isPrimitive() || !JavaIntrospectionHelper.primitiveAssignable(field.getType(), type))) continue;
            candidate = field;
        }
        if (candidate != null) {
            return candidate;
        }
        return null;
    }

    public static Method findClosestMatchingMethod(String name, Class[] types, Set<Method> methods) {
        if (types == null) {
            types = EMPTY_CLASS_ARRY;
        }
        Method candidate = null;
        for (Method method : methods) {
            if (!method.getName().equals(name) || method.getParameterTypes().length != types.length) continue;
            Class<?>[] params = method.getParameterTypes();
            boolean disqualify = false;
            boolean exactMatch = true;
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].equals(types[i]) && !params[i].isAssignableFrom(types[i])) {
                    disqualify = true;
                    exactMatch = false;
                    break;
                }
                if (params[i].equals(types[i]) || !params[i].isAssignableFrom(types[i])) continue;
                exactMatch = false;
            }
            if (disqualify) continue;
            if (exactMatch) {
                return method;
            }
            candidate = method;
        }
        if (candidate != null) {
            return candidate;
        }
        return null;
    }

    public static boolean exactMethodMatch(Method method1, Method method2) {
        Class<?>[] types2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] types1 = method1.getParameterTypes();
        if (types1.length != (types2 = method2.getParameterTypes()).length) {
            return false;
        }
        boolean matched = true;
        for (int i = 0; i < types1.length; ++i) {
            if (types1[i] == types2[i]) continue;
            matched = false;
            break;
        }
        return matched;
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) throws NoSuchMethodException {
        return clazz.getConstructor(new Class[0]);
    }

    public static String getBaseName(Class<?> implClass) {
        return implClass.getSimpleName();
    }

    public static boolean isImmutable(Class<?> clazz) {
        return String.class == clazz || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz);
    }

    public static String toGetter(String name) {
        return "get" + name.toUpperCase().substring(0, 1) + name.substring(1);
    }

    public static String toPropertyName(Method method) {
        if (JavaIntrospectionHelper.isGetter(method) || JavaIntrospectionHelper.isSetter(method)) {
            String name = method.getName();
            if (name.startsWith("get") || name.startsWith("set")) {
                return Introspector.decapitalize(name.substring(3));
            }
            return Introspector.decapitalize(name.substring(2));
        }
        throw new IllegalArgumentException("Method is not a setter or getter: " + method);
    }

    public static Class<?> getErasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return JavaIntrospectionHelper.getErasure(arrayType.getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return JavaIntrospectionHelper.getErasure(pType.getRawType());
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            Type[] types = wType.getUpperBounds();
            return JavaIntrospectionHelper.getErasure(types[0]);
        }
        if (type instanceof TypeVariable) {
            TypeVariable var = (TypeVariable)type;
            Type[] types = var.getBounds();
            return JavaIntrospectionHelper.getErasure(types[0]);
        }
        return null;
    }

    public static Class<?> getBaseType(Class<?> cls, Type genericType) {
        if (cls.isArray()) {
            return cls.getComponentType();
        }
        if (Collection.class.isAssignableFrom(cls)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Type baseType = parameterizedType.getActualTypeArguments()[0];
                if (baseType instanceof GenericArrayType) {
                    return cls;
                }
                return JavaIntrospectionHelper.getErasure(baseType);
            }
            return cls;
        }
        return cls;
    }

    public static Type getParameterType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type baseType = parameterizedType.getActualTypeArguments()[0];
            return baseType;
        }
        return Object.class;
    }

    public static Class<?> getBusinessInterface(Class<?> cls, Type callableReferenceType) {
        if (ServiceReference.class.isAssignableFrom(cls) && callableReferenceType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)callableReferenceType;
            Type baseType = parameterizedType.getActualTypeArguments()[0];
            if (baseType instanceof GenericArrayType) {
                return cls;
            }
            return JavaIntrospectionHelper.getErasure(baseType);
        }
        return Object.class;
    }

    public static String toSetter(String name) {
        return "set" + name.toUpperCase().substring(0, 1) + name.substring(1);
    }

    private static boolean primitiveAssignable(Class<?> memberType, Class<?> param) {
        if (memberType == Integer.class) {
            return param == Integer.TYPE;
        }
        if (memberType == Double.class) {
            return param == Double.TYPE;
        }
        if (memberType == Float.class) {
            return param == Float.TYPE;
        }
        if (memberType == Short.class) {
            return param == Short.TYPE;
        }
        if (memberType == Character.class) {
            return param == Character.TYPE;
        }
        if (memberType == Boolean.class) {
            return param == Boolean.TYPE;
        }
        if (memberType == Byte.class) {
            return param == Byte.TYPE;
        }
        if (param == Integer.class) {
            return memberType == Integer.TYPE;
        }
        if (param == Double.class) {
            return memberType == Double.TYPE;
        }
        if (param == Float.class) {
            return memberType == Float.TYPE;
        }
        if (param == Short.class) {
            return memberType == Short.TYPE;
        }
        if (param == Character.class) {
            return memberType == Character.TYPE;
        }
        if (param == Boolean.class) {
            return memberType == Boolean.TYPE;
        }
        if (param == Byte.class) {
            return memberType == Byte.TYPE;
        }
        return false;
    }

    public static List<? extends Type> getGenerics(Type genericType) {
        ArrayList<Type> classes = new ArrayList<Type>();
        if (genericType instanceof ParameterizedType) {
            Type[] targs;
            ParameterizedType ptype = (ParameterizedType)genericType;
            for (Type targ : targs = ptype.getActualTypeArguments()) {
                classes.add(targ);
            }
        }
        return classes;
    }

    public static Class introspectGeneric(Class<?> clazz, int pos) {
        Type[] interfaces;
        assert (clazz != null) : "No class specified";
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            if (args.length <= pos) {
                throw new IllegalArgumentException("Invalid index value for generic class " + clazz.getName());
            }
            return (Class)((ParameterizedType)type).getActualTypeArguments()[pos];
        }
        for (Type itype : interfaces = clazz.getGenericInterfaces()) {
            if (!(itype instanceof ParameterizedType)) continue;
            ParameterizedType interfaceType = (ParameterizedType)itype;
            return (Class)interfaceType.getActualTypeArguments()[0];
        }
        return null;
    }

    public List<Class<?>> getAllInterfaces(Class<?> clazz) {
        ArrayList implemented = new ArrayList();
        JavaIntrospectionHelper.getAllInterfaces(clazz, implemented);
        return implemented;
    }

    private static void getAllInterfaces(Class<?> clazz, List<Class<?>> implemented) {
        Class<?>[] interfaces;
        for (Class<?> interfaze : interfaces = clazz.getInterfaces()) {
            if (implemented.contains(interfaze)) continue;
            implemented.add(interfaze);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            JavaIntrospectionHelper.getAllInterfaces(superClass, implemented);
        }
    }

    public static boolean isSetter(Method method) {
        return Void.TYPE == method.getReturnType() && method.getParameterTypes().length == 1 && method.getName().startsWith("set") && method.getName().length() > 3;
    }

    public static boolean isGetter(Method method) {
        if (method.getParameterTypes().length == 0) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return false;
        }
        String name = method.getName();
        if (returnType == Boolean.TYPE && name.length() > 2 && name.startsWith("is")) {
            return true;
        }
        return name.length() > 3 && name.startsWith("get");
    }

    public static String getSignature(Class<?> cls) {
        if (cls.isPrimitive()) {
            return signatures.get(cls);
        }
        if (cls.isArray()) {
            return "[" + JavaIntrospectionHelper.getSignature(cls.getComponentType());
        }
        return "L" + cls.getName().replace('.', '/') + ";";
    }

    public static Class<?> getArrayType(Class<?> componentType, int dims) throws ClassNotFoundException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < dims; ++i) {
            buf.append('[');
        }
        buf.append(JavaIntrospectionHelper.getSignature(componentType));
        return Class.forName(buf.toString(), false, componentType.getClassLoader());
    }

    static {
        signatures.put(Boolean.TYPE, "Z");
        signatures.put(Byte.TYPE, "B");
        signatures.put(Character.TYPE, "C");
        signatures.put(Short.TYPE, "S");
        signatures.put(Integer.TYPE, "I");
        signatures.put(Long.TYPE, "J");
        signatures.put(Float.TYPE, "F");
        signatures.put(Double.TYPE, "D");
    }
}

