/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.java.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompoundIterator<T>
implements Iterator<T> {
    private Iterator<T>[] iterators = null;
    private int index = 0;

    public CompoundIterator(Iterator<T> ... iterators) {
        this.iterators = iterators;
    }

    public CompoundIterator(Collection<T> ... collections) {
        this.iterators = new Iterator[collections.length];
        for (int i = 0; i < collections.length; ++i) {
            this.iterators[i] = collections[i].iterator();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator() == null) {
            return false;
        }
        return this.currentIterator().hasNext();
    }

    private Iterator<T> findNextIterator(boolean moveCursor) {
        return this.findNextIterator(this.index, moveCursor);
    }

    private Iterator<T> findNextIterator(int cursor, boolean moveCursor) {
        int next = cursor + 1;
        if (next < this.iterators.length) {
            if (this.iterators[next] != null && this.iterators[next].hasNext()) {
                if (moveCursor) {
                    this.index = next;
                }
                return this.iterators[next];
            }
            return this.findNextIterator(next, moveCursor);
        }
        return null;
    }

    @Override
    public T next() {
        if (this.currentIterator() != null) {
            return this.currentIterator().next();
        }
        throw new NoSuchElementException("No more elements");
    }

    @Override
    public void remove() {
        if (this.currentIterator() != null) {
            this.currentIterator().remove();
        }
        throw new NoSuchElementException("No more elements");
    }

    private Iterator<T> currentIterator() {
        if (this.iterators != null && this.index < this.iterators.length) {
            Iterator<T> e = this.iterators[this.index];
            if (e == null || !e.hasNext()) {
                e = this.findNextIterator(true);
            }
            return e;
        }
        return null;
    }
}

