/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.java.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.apache.tuscany.sca.common.java.collection.CompoundEnumeration;

public class ClassLoaderDelegate
extends ClassLoader {
    private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public ClassLoaderDelegate(ClassLoader parent, ClassLoader ... loaders) {
        super(parent);
        if (loaders != null) {
            for (ClassLoader cl : loaders) {
                if (cl == null || cl == parent || this.classLoaders.contains(cl)) continue;
                this.classLoaders.add(cl);
            }
        }
    }

    public ClassLoaderDelegate(ClassLoader parent, Collection<ClassLoader> loaders) {
        super(parent);
        if (loaders != null) {
            for (ClassLoader cl : loaders) {
                if (cl == null || cl == parent || this.classLoaders.contains(cl)) continue;
                this.classLoaders.add(cl);
            }
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        for (ClassLoader parent : this.classLoaders) {
            try {
                return parent.loadClass(className);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    protected URL findResource(String resName) {
        for (ClassLoader parent : this.classLoaders) {
            URL url = parent.getResource(resName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String resName) throws IOException {
        Enumeration[] enums = new Enumeration[this.classLoaders.size()];
        int index = 0;
        for (ClassLoader parent : this.classLoaders) {
            enums[index++] = parent.getResources(resName);
        }
        return new CompoundEnumeration<URL>(enums);
    }
}

